// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the delivery configuration settings for sending a campaign or campaign treatment through a custom channel. This object is required if you use the CampaignCustomMessage object to define the message to send for the campaign or campaign treatment.
 */
public class CustomDeliveryConfiguration private constructor(builder: Builder) {
    /**
     * The destination to send the campaign or treatment to. This value can be one of the following:
     * + The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.
     * + The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.
     */
    public val deliveryUri: kotlin.String? = builder.deliveryUri
    /**
     * The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.
     */
    public val endpointTypes: List<EndpointTypesElement>? = builder.endpointTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDeliveryConfiguration(")
        append("deliveryUri=$deliveryUri,")
        append("endpointTypes=$endpointTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryUri?.hashCode() ?: 0
        result = 31 * result + (endpointTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomDeliveryConfiguration

        if (deliveryUri != other.deliveryUri) return false
        if (endpointTypes != other.endpointTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination to send the campaign or treatment to. This value can be one of the following:
         * + The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.
         * + The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.
         */
        public var deliveryUri: kotlin.String? = null
        /**
         * The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.
         */
        public var endpointTypes: List<EndpointTypesElement>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration) : this() {
            this.deliveryUri = x.deliveryUri
            this.endpointTypes = x.endpointTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CustomDeliveryConfiguration = CustomDeliveryConfiguration(this)
    }
}
