// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.
 */
public class BaiduChannelResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the Baidu channel applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The date and time when the Baidu channel was enabled.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The API key that you received from the Baidu Cloud Push service to communicate with the service.
     */
    public val credential: kotlin.String? = builder.credential
    /**
     * Specifies whether the Baidu channel is enabled for the application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * (Not used) This property is retained only for backward compatibility.
     */
    public val hasCredential: kotlin.Boolean? = builder.hasCredential
    /**
     * (Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies whether the Baidu channel is archived.
     */
    public val isArchived: kotlin.Boolean? = builder.isArchived
    /**
     * The user who last modified the Baidu channel.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time when the Baidu channel was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The current version of the Baidu channel.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.BaiduChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BaiduChannelResponse(")
        append("applicationId=$applicationId,")
        append("creationDate=$creationDate,")
        append("credential=$credential,")
        append("enabled=$enabled,")
        append("hasCredential=$hasCredential,")
        append("id=$id,")
        append("isArchived=$isArchived,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("platform=$platform,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (credential?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (hasCredential?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isArchived?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BaiduChannelResponse

        if (applicationId != other.applicationId) return false
        if (creationDate != other.creationDate) return false
        if (credential != other.credential) return false
        if (enabled != other.enabled) return false
        if (hasCredential != other.hasCredential) return false
        if (id != other.id) return false
        if (isArchived != other.isArchived) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (platform != other.platform) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.BaiduChannelResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that the Baidu channel applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The date and time when the Baidu channel was enabled.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The API key that you received from the Baidu Cloud Push service to communicate with the service.
         */
        public var credential: kotlin.String? = null
        /**
         * Specifies whether the Baidu channel is enabled for the application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * (Not used) This property is retained only for backward compatibility.
         */
        public var hasCredential: kotlin.Boolean? = null
        /**
         * (Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether the Baidu channel is archived.
         */
        public var isArchived: kotlin.Boolean? = null
        /**
         * The user who last modified the Baidu channel.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time when the Baidu channel was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.
         */
        public var platform: kotlin.String? = null
        /**
         * The current version of the Baidu channel.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.BaiduChannelResponse) : this() {
            this.applicationId = x.applicationId
            this.creationDate = x.creationDate
            this.credential = x.credential
            this.enabled = x.enabled
            this.hasCredential = x.hasCredential
            this.id = x.id
            this.isArchived = x.isArchived
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedDate = x.lastModifiedDate
            this.platform = x.platform
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.BaiduChannelResponse = BaiduChannelResponse(this)
    }
}
