// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.
 */
public class ApnsVoipSandboxChannelRequest private constructor(builder: Builder) {
    /**
     * The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.
     */
    public val certificate: kotlin.String? = builder.certificate
    /**
     * The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.
     */
    public val defaultAuthenticationMethod: kotlin.String? = builder.defaultAuthenticationMethod
    /**
     * Specifies whether the APNs VoIP sandbox channel is enabled for the application.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.
     */
    public val privateKey: kotlin.String? = builder.privateKey
    /**
     * The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.
     */
    public val teamId: kotlin.String? = builder.teamId
    /**
     * The authentication key to use for APNs tokens.
     */
    public val tokenKey: kotlin.String? = builder.tokenKey
    /**
     * The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.
     */
    public val tokenKeyId: kotlin.String? = builder.tokenKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipSandboxChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApnsVoipSandboxChannelRequest(")
        append("bundleId=$bundleId,")
        append("certificate=$certificate,")
        append("defaultAuthenticationMethod=$defaultAuthenticationMethod,")
        append("enabled=$enabled,")
        append("privateKey=$privateKey,")
        append("teamId=$teamId,")
        append("tokenKey=$tokenKey,")
        append("tokenKeyId=$tokenKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (defaultAuthenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        result = 31 * result + (teamId?.hashCode() ?: 0)
        result = 31 * result + (tokenKey?.hashCode() ?: 0)
        result = 31 * result + (tokenKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApnsVoipSandboxChannelRequest

        if (bundleId != other.bundleId) return false
        if (certificate != other.certificate) return false
        if (defaultAuthenticationMethod != other.defaultAuthenticationMethod) return false
        if (enabled != other.enabled) return false
        if (privateKey != other.privateKey) return false
        if (teamId != other.teamId) return false
        if (tokenKey != other.tokenKey) return false
        if (tokenKeyId != other.tokenKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipSandboxChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.
         */
        public var certificate: kotlin.String? = null
        /**
         * The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.
         */
        public var defaultAuthenticationMethod: kotlin.String? = null
        /**
         * Specifies whether the APNs VoIP sandbox channel is enabled for the application.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.
         */
        public var privateKey: kotlin.String? = null
        /**
         * The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.
         */
        public var teamId: kotlin.String? = null
        /**
         * The authentication key to use for APNs tokens.
         */
        public var tokenKey: kotlin.String? = null
        /**
         * The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.
         */
        public var tokenKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApnsVoipSandboxChannelRequest) : this() {
            this.bundleId = x.bundleId
            this.certificate = x.certificate
            this.defaultAuthenticationMethod = x.defaultAuthenticationMethod
            this.enabled = x.enabled
            this.privateKey = x.privateKey
            this.teamId = x.teamId
            this.tokenKey = x.tokenKey
            this.tokenKeyId = x.tokenKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipSandboxChannelRequest = ApnsVoipSandboxChannelRequest(this)
    }
}
