// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the APNs (Apple Push Notification service) channel.
 */
public class ApnsPushNotificationTemplate private constructor(builder: Builder) {
    /**
     * The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The message body to use in push notifications that are based on the message template.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The URL of an image or video to display in push notifications that are based on the message template.
     */
    public val mediaUrl: kotlin.String? = builder.mediaUrl
    /**
     * The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.
     */
    public val rawContent: kotlin.String? = builder.rawContent
    /**
     * The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
     */
    public val sound: kotlin.String? = builder.sound
    /**
     * The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApnsPushNotificationTemplate(")
        append("action=$action,")
        append("body=$body,")
        append("mediaUrl=$mediaUrl,")
        append("rawContent=$rawContent,")
        append("sound=$sound,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (mediaUrl?.hashCode() ?: 0)
        result = 31 * result + (rawContent?.hashCode() ?: 0)
        result = 31 * result + (sound?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApnsPushNotificationTemplate

        if (action != other.action) return false
        if (body != other.body) return false
        if (mediaUrl != other.mediaUrl) return false
        if (rawContent != other.rawContent) return false
        if (sound != other.sound) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to occur if a recipient taps a push notification that's based on the message template. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The message body to use in push notifications that are based on the message template.
         */
        public var body: kotlin.String? = null
        /**
         * The URL of an image or video to display in push notifications that are based on the message template.
         */
        public var mediaUrl: kotlin.String? = null
        /**
         * The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.
         */
        public var rawContent: kotlin.String? = null
        /**
         * The key for the sound to play when the recipient receives a push notification that's based on the message template. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
         */
        public var sound: kotlin.String? = null
        /**
         * The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate) : this() {
            this.action = x.action
            this.body = x.body
            this.mediaUrl = x.mediaUrl
            this.rawContent = x.rawContent
            this.sound = x.sound
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApnsPushNotificationTemplate = ApnsPushNotificationTemplate(this)
    }
}
