// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a one-time message that's sent directly to an endpoint through the APNs (Apple Push Notification service) channel.
 */
public class ApnsMessage private constructor(builder: Builder) {
    /**
     * The action to occur if the recipient taps the push notification. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The type of push notification to send. Valid values are:
     * + alert - For a standard notification that's displayed on recipients' devices and prompts a recipient to interact with the notification.
     * + background - For a silent notification that delivers content in the background and isn't displayed on recipients' devices.
     * + complication - For a notification that contains update information for an app’s complication timeline.
     * + fileprovider - For a notification that signals changes to a File Provider extension.
     * + mdm - For a notification that tells managed devices to contact the MDM server.
     * + voip - For a notification that provides information about an incoming VoIP call.
     *
     * Amazon Pinpoint specifies this value in the apns-push-type request header when it sends the notification message to APNs. If you don't specify a value for this property, Amazon Pinpoint sets the value to alert or background automatically, based on the value that you specify for the SilentPush or RawContent property of the message.
     *
     * For more information about the apns-push-type request header, see [Sending Notification Requests to APNs](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/sending_notification_requests_to_apns) on the Apple Developer website.
     */
    public val apnsPushType: kotlin.String? = builder.apnsPushType
    /**
     * The key that indicates whether and how to modify the badge of your app's icon when the recipient receives the push notification. If this key isn't included in the dictionary, the badge doesn't change. To remove the badge, set this value to 0.
     */
    public val badge: kotlin.Int? = builder.badge
    /**
     * The body of the notification message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The key that indicates the notification type for the push notification. This key is a value that's defined by the identifier property of one of your app's registered categories.
     */
    public val category: kotlin.String? = builder.category
    /**
     * An arbitrary identifier that, if assigned to multiple messages, APNs uses to coalesce the messages into a single push notification instead of delivering each message individually. This value can't exceed 64 bytes.
     *
     * Amazon Pinpoint specifies this value in the apns-collapse-id request header when it sends the notification message to APNs.
     */
    public val collapseId: kotlin.String? = builder.collapseId
    /**
     * The JSON payload to use for a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
     */
    public val data: Map<String, String>? = builder.data
    /**
     * The URL of an image or video to display in the push notification.
     */
    public val mediaUrl: kotlin.String? = builder.mediaUrl
    /**
     * The authentication method that you want Amazon Pinpoint to use when authenticating with APNs, CERTIFICATE or TOKEN.
     */
    public val preferredAuthenticationMethod: kotlin.String? = builder.preferredAuthenticationMethod
    /**
     * para>5 - Low priority, the notification might be delayed, delivered as part of a group, or throttled.
     *
     * /listitem> + 10 - High priority, the notification is sent immediately. This is the default value. A high priority notification should trigger an alert, play a sound, or badge your app's icon on the recipient's device.
     *
     * /para> Amazon Pinpoint specifies this value in the apns-priority request header when it sends the notification message to APNs.
     *
     * The equivalent values for Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify an FCM value for this property, Amazon Pinpoint accepts and converts the value to the corresponding APNs value.
     */
    public val priority: kotlin.String? = builder.priority
    /**
     * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
     *
     * If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. The value of the content-available key has to be an integer, and can only be 0 or 1. If you're sending a standard notification, set the value of content-available to 0. If you're sending a silent (background) notification, set the value of content-available to 1. Additionally, silent notification payloads can't include the alert, badge, or sound keys. For more information, see [Generating a Remote Notification](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification) and [Pushing Background Updates to Your App](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app) on the Apple Developer website.
     */
    public val rawContent: kotlin.String? = builder.rawContent
    /**
     * Specifies whether the notification is a silent push notification. A silent (or background) push notification isn't displayed on recipients' devices. You can use silent push notifications to make small updates to your app, or to display messages in an in-app message center.
     *
     * Amazon Pinpoint uses this property to determine the correct value for the apns-push-type request header when it sends the notification message to APNs. If you specify a value of true for this property, Amazon Pinpoint sets the value for the apns-push-type header field to background.
     *
     * If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. For silent (background) notifications, set the value of content-available to 1. Additionally, the message payload for a silent notification can't include the alert, badge, or sound keys. For more information, see [Generating a Remote Notification](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification) and [Pushing Background Updates to Your App](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app) on the Apple Developer website.
     *
     * Apple has indicated that they will throttle "excessive" background notifications based on current traffic volumes. To prevent your notifications being throttled, Apple recommends that you send no more than 3 silent push notifications to each recipient per hour.
     */
    public val silentPush: kotlin.Boolean? = builder.silentPush
    /**
     * The key for the sound to play when the recipient receives the push notification. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
     */
    public val sound: kotlin.String? = builder.sound
    /**
     * The default message variables to use in the notification message. You can override these default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The key that represents your app-specific identifier for grouping notifications. If you provide a Notification Content app extension, you can use this value to group your notifications together.
     */
    public val threadId: kotlin.String? = builder.threadId
    /**
     * The amount of time, in seconds, that APNs should store and attempt to deliver the push notification, if the service is unable to deliver the notification the first time. If this value is 0, APNs treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
     *
     * Amazon Pinpoint specifies this value in the apns-expiration request header when it sends the notification message to APNs.
     */
    public val timeToLive: kotlin.Int? = builder.timeToLive
    /**
     * The title to display above the notification message on the recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The URL to open in the recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApnsMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApnsMessage(")
        append("action=$action,")
        append("apnsPushType=$apnsPushType,")
        append("badge=$badge,")
        append("body=$body,")
        append("category=$category,")
        append("collapseId=$collapseId,")
        append("data=$data,")
        append("mediaUrl=$mediaUrl,")
        append("preferredAuthenticationMethod=$preferredAuthenticationMethod,")
        append("priority=$priority,")
        append("rawContent=$rawContent,")
        append("silentPush=$silentPush,")
        append("sound=$sound,")
        append("substitutions=$substitutions,")
        append("threadId=$threadId,")
        append("timeToLive=$timeToLive,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (apnsPushType?.hashCode() ?: 0)
        result = 31 * result + (badge ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (collapseId?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (mediaUrl?.hashCode() ?: 0)
        result = 31 * result + (preferredAuthenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (priority?.hashCode() ?: 0)
        result = 31 * result + (rawContent?.hashCode() ?: 0)
        result = 31 * result + (silentPush?.hashCode() ?: 0)
        result = 31 * result + (sound?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (threadId?.hashCode() ?: 0)
        result = 31 * result + (timeToLive ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApnsMessage

        if (action != other.action) return false
        if (apnsPushType != other.apnsPushType) return false
        if (badge != other.badge) return false
        if (body != other.body) return false
        if (category != other.category) return false
        if (collapseId != other.collapseId) return false
        if (data != other.data) return false
        if (mediaUrl != other.mediaUrl) return false
        if (preferredAuthenticationMethod != other.preferredAuthenticationMethod) return false
        if (priority != other.priority) return false
        if (rawContent != other.rawContent) return false
        if (silentPush != other.silentPush) return false
        if (sound != other.sound) return false
        if (substitutions != other.substitutions) return false
        if (threadId != other.threadId) return false
        if (timeToLive != other.timeToLive) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApnsMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to occur if the recipient taps the push notification. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The type of push notification to send. Valid values are:
         * + alert - For a standard notification that's displayed on recipients' devices and prompts a recipient to interact with the notification.
         * + background - For a silent notification that delivers content in the background and isn't displayed on recipients' devices.
         * + complication - For a notification that contains update information for an app’s complication timeline.
         * + fileprovider - For a notification that signals changes to a File Provider extension.
         * + mdm - For a notification that tells managed devices to contact the MDM server.
         * + voip - For a notification that provides information about an incoming VoIP call.
         *
         * Amazon Pinpoint specifies this value in the apns-push-type request header when it sends the notification message to APNs. If you don't specify a value for this property, Amazon Pinpoint sets the value to alert or background automatically, based on the value that you specify for the SilentPush or RawContent property of the message.
         *
         * For more information about the apns-push-type request header, see [Sending Notification Requests to APNs](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/sending_notification_requests_to_apns) on the Apple Developer website.
         */
        public var apnsPushType: kotlin.String? = null
        /**
         * The key that indicates whether and how to modify the badge of your app's icon when the recipient receives the push notification. If this key isn't included in the dictionary, the badge doesn't change. To remove the badge, set this value to 0.
         */
        public var badge: kotlin.Int? = null
        /**
         * The body of the notification message.
         */
        public var body: kotlin.String? = null
        /**
         * The key that indicates the notification type for the push notification. This key is a value that's defined by the identifier property of one of your app's registered categories.
         */
        public var category: kotlin.String? = null
        /**
         * An arbitrary identifier that, if assigned to multiple messages, APNs uses to coalesce the messages into a single push notification instead of delivering each message individually. This value can't exceed 64 bytes.
         *
         * Amazon Pinpoint specifies this value in the apns-collapse-id request header when it sends the notification message to APNs.
         */
        public var collapseId: kotlin.String? = null
        /**
         * The JSON payload to use for a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
         */
        public var data: Map<String, String>? = null
        /**
         * The URL of an image or video to display in the push notification.
         */
        public var mediaUrl: kotlin.String? = null
        /**
         * The authentication method that you want Amazon Pinpoint to use when authenticating with APNs, CERTIFICATE or TOKEN.
         */
        public var preferredAuthenticationMethod: kotlin.String? = null
        /**
         * para>5 - Low priority, the notification might be delayed, delivered as part of a group, or throttled.
         *
         * /listitem> + 10 - High priority, the notification is sent immediately. This is the default value. A high priority notification should trigger an alert, play a sound, or badge your app's icon on the recipient's device.
         *
         * /para> Amazon Pinpoint specifies this value in the apns-priority request header when it sends the notification message to APNs.
         *
         * The equivalent values for Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify an FCM value for this property, Amazon Pinpoint accepts and converts the value to the corresponding APNs value.
         */
        public var priority: kotlin.String? = null
        /**
         * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
         *
         * If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. The value of the content-available key has to be an integer, and can only be 0 or 1. If you're sending a standard notification, set the value of content-available to 0. If you're sending a silent (background) notification, set the value of content-available to 1. Additionally, silent notification payloads can't include the alert, badge, or sound keys. For more information, see [Generating a Remote Notification](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification) and [Pushing Background Updates to Your App](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app) on the Apple Developer website.
         */
        public var rawContent: kotlin.String? = null
        /**
         * Specifies whether the notification is a silent push notification. A silent (or background) push notification isn't displayed on recipients' devices. You can use silent push notifications to make small updates to your app, or to display messages in an in-app message center.
         *
         * Amazon Pinpoint uses this property to determine the correct value for the apns-push-type request header when it sends the notification message to APNs. If you specify a value of true for this property, Amazon Pinpoint sets the value for the apns-push-type header field to background.
         *
         * If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. For silent (background) notifications, set the value of content-available to 1. Additionally, the message payload for a silent notification can't include the alert, badge, or sound keys. For more information, see [Generating a Remote Notification](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification) and [Pushing Background Updates to Your App](https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app) on the Apple Developer website.
         *
         * Apple has indicated that they will throttle "excessive" background notifications based on current traffic volumes. To prevent your notifications being throttled, Apple recommends that you send no more than 3 silent push notifications to each recipient per hour.
         */
        public var silentPush: kotlin.Boolean? = null
        /**
         * The key for the sound to play when the recipient receives the push notification. The value for this key is the name of a sound file in your app's main bundle or the Library/Sounds folder in your app's data container. If the sound file can't be found or you specify default for the value, the system plays the default alert sound.
         */
        public var sound: kotlin.String? = null
        /**
         * The default message variables to use in the notification message. You can override these default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The key that represents your app-specific identifier for grouping notifications. If you provide a Notification Content app extension, you can use this value to group your notifications together.
         */
        public var threadId: kotlin.String? = null
        /**
         * The amount of time, in seconds, that APNs should store and attempt to deliver the push notification, if the service is unable to deliver the notification the first time. If this value is 0, APNs treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
         *
         * Amazon Pinpoint specifies this value in the apns-expiration request header when it sends the notification message to APNs.
         */
        public var timeToLive: kotlin.Int? = null
        /**
         * The title to display above the notification message on the recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The URL to open in the recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApnsMessage) : this() {
            this.action = x.action
            this.apnsPushType = x.apnsPushType
            this.badge = x.badge
            this.body = x.body
            this.category = x.category
            this.collapseId = x.collapseId
            this.data = x.data
            this.mediaUrl = x.mediaUrl
            this.preferredAuthenticationMethod = x.preferredAuthenticationMethod
            this.priority = x.priority
            this.rawContent = x.rawContent
            this.silentPush = x.silentPush
            this.sound = x.sound
            this.substitutions = x.substitutions
            this.threadId = x.threadId
            this.timeToLive = x.timeToLive
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApnsMessage = ApnsMessage(this)
    }
}
