// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a one-time message that's sent directly to an endpoint through the ADM (Amazon Device Messaging) channel.
 */
public class AdmMessage private constructor(builder: Builder) {
    /**
     * The action to occur if the recipient taps the push notification. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The body of the notification message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * An arbitrary string that indicates that multiple messages are logically the same and that Amazon Device Messaging (ADM) can drop previously enqueued messages in favor of this message.
     */
    public val consolidationKey: kotlin.String? = builder.consolidationKey
    /**
     * The JSON data payload to use for the push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
     */
    public val data: Map<String, String>? = builder.data
    /**
     * The amount of time, in seconds, that ADM should store the message if the recipient's device is offline. Amazon Pinpoint specifies this value in the expiresAfter parameter when it sends the notification message to ADM.
     */
    public val expiresAfter: kotlin.String? = builder.expiresAfter
    /**
     * The icon image name of the asset saved in your app.
     */
    public val iconReference: kotlin.String? = builder.iconReference
    /**
     * The URL of the large icon image to display in the content view of the push notification.
     */
    public val imageIconUrl: kotlin.String? = builder.imageIconUrl
    /**
     * The URL of an image to display in the push notification.
     */
    public val imageUrl: kotlin.String? = builder.imageUrl
    /**
     * The base64-encoded, MD5 checksum of the value specified by the Data property. ADM uses the MD5 value to verify the integrity of the data.
     */
    public val md5: kotlin.String? = builder.md5
    /**
     * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
     */
    public val rawContent: kotlin.String? = builder.rawContent
    /**
     * Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration or supporting phone home functionality.
     */
    public val silentPush: kotlin.Boolean? = builder.silentPush
    /**
     * The URL of the small icon image to display in the status bar and the content view of the push notification.
     */
    public val smallImageIconUrl: kotlin.String? = builder.smallImageIconUrl
    /**
     * The sound to play when the recipient receives the push notification. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.
     */
    public val sound: kotlin.String? = builder.sound
    /**
     * The default message variables to use in the notification message. You can override the default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The title to display above the notification message on the recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The URL to open in the recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.AdmMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdmMessage(")
        append("action=$action,")
        append("body=$body,")
        append("consolidationKey=$consolidationKey,")
        append("data=$data,")
        append("expiresAfter=$expiresAfter,")
        append("iconReference=$iconReference,")
        append("imageIconUrl=$imageIconUrl,")
        append("imageUrl=$imageUrl,")
        append("md5=$md5,")
        append("rawContent=$rawContent,")
        append("silentPush=$silentPush,")
        append("smallImageIconUrl=$smallImageIconUrl,")
        append("sound=$sound,")
        append("substitutions=$substitutions,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (consolidationKey?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (expiresAfter?.hashCode() ?: 0)
        result = 31 * result + (iconReference?.hashCode() ?: 0)
        result = 31 * result + (imageIconUrl?.hashCode() ?: 0)
        result = 31 * result + (imageUrl?.hashCode() ?: 0)
        result = 31 * result + (md5?.hashCode() ?: 0)
        result = 31 * result + (rawContent?.hashCode() ?: 0)
        result = 31 * result + (silentPush?.hashCode() ?: 0)
        result = 31 * result + (smallImageIconUrl?.hashCode() ?: 0)
        result = 31 * result + (sound?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdmMessage

        if (action != other.action) return false
        if (body != other.body) return false
        if (consolidationKey != other.consolidationKey) return false
        if (data != other.data) return false
        if (expiresAfter != other.expiresAfter) return false
        if (iconReference != other.iconReference) return false
        if (imageIconUrl != other.imageIconUrl) return false
        if (imageUrl != other.imageUrl) return false
        if (md5 != other.md5) return false
        if (rawContent != other.rawContent) return false
        if (silentPush != other.silentPush) return false
        if (smallImageIconUrl != other.smallImageIconUrl) return false
        if (sound != other.sound) return false
        if (substitutions != other.substitutions) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.AdmMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to occur if the recipient taps the push notification. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The body of the notification message.
         */
        public var body: kotlin.String? = null
        /**
         * An arbitrary string that indicates that multiple messages are logically the same and that Amazon Device Messaging (ADM) can drop previously enqueued messages in favor of this message.
         */
        public var consolidationKey: kotlin.String? = null
        /**
         * The JSON data payload to use for the push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.
         */
        public var data: Map<String, String>? = null
        /**
         * The amount of time, in seconds, that ADM should store the message if the recipient's device is offline. Amazon Pinpoint specifies this value in the expiresAfter parameter when it sends the notification message to ADM.
         */
        public var expiresAfter: kotlin.String? = null
        /**
         * The icon image name of the asset saved in your app.
         */
        public var iconReference: kotlin.String? = null
        /**
         * The URL of the large icon image to display in the content view of the push notification.
         */
        public var imageIconUrl: kotlin.String? = null
        /**
         * The URL of an image to display in the push notification.
         */
        public var imageUrl: kotlin.String? = null
        /**
         * The base64-encoded, MD5 checksum of the value specified by the Data property. ADM uses the MD5 value to verify the integrity of the data.
         */
        public var md5: kotlin.String? = null
        /**
         * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
         */
        public var rawContent: kotlin.String? = null
        /**
         * Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration or supporting phone home functionality.
         */
        public var silentPush: kotlin.Boolean? = null
        /**
         * The URL of the small icon image to display in the status bar and the content view of the push notification.
         */
        public var smallImageIconUrl: kotlin.String? = null
        /**
         * The sound to play when the recipient receives the push notification. You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in /res/raw/.
         */
        public var sound: kotlin.String? = null
        /**
         * The default message variables to use in the notification message. You can override the default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The title to display above the notification message on the recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The URL to open in the recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.AdmMessage) : this() {
            this.action = x.action
            this.body = x.body
            this.consolidationKey = x.consolidationKey
            this.data = x.data
            this.expiresAfter = x.expiresAfter
            this.iconReference = x.iconReference
            this.imageIconUrl = x.imageIconUrl
            this.imageUrl = x.imageUrl
            this.md5 = x.md5
            this.rawContent = x.rawContent
            this.silentPush = x.silentPush
            this.smallImageIconUrl = x.smallImageIconUrl
            this.sound = x.sound
            this.substitutions = x.substitutions
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.AdmMessage = AdmMessage(this)
    }
}
