// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.endpoints

import aws.sdk.kotlin.services.pinpoint.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultPinpointEndpointProvider: PinpointEndpointProvider {
    public override suspend fun resolveEndpoint(params: PinpointEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint, UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://pinpoint-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://pinpoint-fips.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://pinpoint.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "us-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://pinpoint.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        params.region == "us-west-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://pinpoint.us-west-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        params.region == "us-gov-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://pinpoint.us-gov-west-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        "aws" == partitionResult?.name
                    ) {
                        return Endpoint(
                            Url.parse("https://pinpoint.${params.region}.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        "aws-us-gov" == partitionResult?.name
                    ) {
                        return Endpoint(
                            Url.parse("https://pinpoint.${params.region}.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    return Endpoint(
                        Url.parse("https://pinpoint.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
