// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.PinpointException
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceChannelResponse
import aws.sdk.kotlin.services.pinpoint.model.VoiceChannelResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateVoiceChannelOperationDeserializer: HttpDeserialize<UpdateVoiceChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateVoiceChannelResponse {
        if (!response.status.isSuccess()) {
            throwUpdateVoiceChannelError(context, response)
        }
        val builder = UpdateVoiceChannelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.voiceChannelResponse = deserializeVoiceChannelResponsePayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwUpdateVoiceChannelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "PayloadTooLargeException" -> PayloadTooLargeExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
