// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.SmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsTemplateRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateSmsTemplateOperationSerializer: HttpSerialize<UpdateSmsTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSmsTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "templates",
                "${input.templateName}".encodeLabel(),
                "sms",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.createNewVersion != false) append("create-new-version", "${input.createNewVersion}")
                if (input.version != null) append("version", input.version)
            }
        }

        if (input.smsTemplateRequest != null) {
            val payload = serializeSmsTemplateRequestPayload(input.smsTemplateRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.smsTemplateRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
