// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.EventsRequest
import aws.sdk.kotlin.services.pinpoint.model.PutEventsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutEventsOperationSerializer: HttpSerialize<PutEventsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apps",
                "${input.applicationId}".encodeLabel(),
                "events",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.eventsRequest != null) {
            val payload = serializeEventsRequestPayload(input.eventsRequest)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.eventsRequest == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
