// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.transform

import aws.sdk.kotlin.services.pinpoint.model.GetJourneyDateRangeKpiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetJourneyDateRangeKpiOperationSerializer: HttpSerialize<GetJourneyDateRangeKpiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetJourneyDateRangeKpiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apps",
                "${input.applicationId}".encodeLabel(),
                "journeys",
                "${input.journeyId}".encodeLabel(),
                "kpis",
                "daterange",
                "${input.kpiName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.endTime != null) append("end-time", input.endTime.format(TimestampFormat.ISO_8601))
                if (input.nextToken != null) append("next-token", input.nextToken)
                if (input.pageSize != null) append("page-size", input.pageSize)
                if (input.startTime != null) append("start-time", input.startTime.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
