// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.
 */
public class WriteSegmentRequest private constructor(builder: Builder) {
    /**
     * The criteria that define the dimensions for the segment.
     */
    public val dimensions: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions? = builder.dimensions
    /**
     * The name of the segment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.
     */
    public val segmentGroups: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList? = builder.segmentGroups
    /**
     * A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.WriteSegmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WriteSegmentRequest(")
        append("dimensions=$dimensions,")
        append("name=$name,")
        append("segmentGroups=$segmentGroups,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (segmentGroups?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WriteSegmentRequest

        if (dimensions != other.dimensions) return false
        if (name != other.name) return false
        if (segmentGroups != other.segmentGroups) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.WriteSegmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The criteria that define the dimensions for the segment.
         */
        public var dimensions: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions? = null
        /**
         * The name of the segment.
         */
        public var name: kotlin.String? = null
        /**
         * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.
         */
        public var segmentGroups: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList? = null
        /**
         * A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.WriteSegmentRequest) : this() {
            this.dimensions = x.dimensions
            this.name = x.name
            this.segmentGroups = x.segmentGroups
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.WriteSegmentRequest = WriteSegmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions] inside the given [block]
         */
        public fun dimensions(block: aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions.Builder.() -> kotlin.Unit) {
            this.dimensions = aws.sdk.kotlin.services.pinpoint.model.SegmentDimensions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList] inside the given [block]
         */
        public fun segmentGroups(block: aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList.Builder.() -> kotlin.Unit) {
            this.segmentGroups = aws.sdk.kotlin.services.pinpoint.model.SegmentGroupList.invoke(block)
        }
    }
}
