// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about a specific version of a message template.
 */
public class TemplateVersionResponse private constructor(builder: Builder) {
    /**
     * The date, in ISO 8601 format, when the version of the message template was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * A JSON object that specifies the default values that are used for message variables in the version of the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The date, in ISO 8601 format, when the version of the message template was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The custom description of the version of the message template.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription
    /**
     * The name of the message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and VOICE.
     */
    public val templateType: kotlin.String? = builder.templateType
    /**
     * The unique identifier for the version of the message template. This value is an integer that Amazon Pinpoint automatically increments and assigns to each new version of a template.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.TemplateVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TemplateVersionResponse(")
        append("creationDate=$creationDate,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("templateDescription=$templateDescription,")
        append("templateName=$templateName,")
        append("templateType=$templateType,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateType?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TemplateVersionResponse

        if (creationDate != other.creationDate) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (templateDescription != other.templateDescription) return false
        if (templateName != other.templateName) return false
        if (templateType != other.templateType) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.TemplateVersionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date, in ISO 8601 format, when the version of the message template was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * A JSON object that specifies the default values that are used for message variables in the version of the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the version of the message template was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The custom description of the version of the message template.
         */
        public var templateDescription: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and VOICE.
         */
        public var templateType: kotlin.String? = null
        /**
         * The unique identifier for the version of the message template. This value is an integer that Amazon Pinpoint automatically increments and assigns to each new version of a template.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.TemplateVersionResponse) : this() {
            this.creationDate = x.creationDate
            this.defaultSubstitutions = x.defaultSubstitutions
            this.lastModifiedDate = x.lastModifiedDate
            this.templateDescription = x.templateDescription
            this.templateName = x.templateName
            this.templateType = x.templateType
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.TemplateVersionResponse = TemplateVersionResponse(this)
    }
}
