// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about a message template that's associated with your Amazon Pinpoint account.
 */
public class TemplateResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the message template. This value isn't included in a TemplateResponse object. To retrieve the ARN of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the ARN for.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date, in ISO 8601 format, when the message template was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The JSON object that specifies the default values that are used for message variables in the message template. This object isn't included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.
     */
    public val defaultSubstitutions: kotlin.String? = builder.defaultSubstitutions
    /**
     * The date, in ISO 8601 format, when the message template was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * A map of key-value pairs that identifies the tags that are associated with the message template. This object isn't included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The custom description of the message template. This value isn't included in a TemplateResponse object. To retrieve the description of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the description for.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription
    /**
     * The name of the message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and VOICE.
     */
    public val templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = builder.templateType
    /**
     * The unique identifier, as an integer, for the active version of the message template.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.TemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TemplateResponse(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("defaultSubstitutions=$defaultSubstitutions,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("tags=$tags,")
        append("templateDescription=$templateDescription,")
        append("templateName=$templateName,")
        append("templateType=$templateType,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (defaultSubstitutions?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateType?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TemplateResponse

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (defaultSubstitutions != other.defaultSubstitutions) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (tags != other.tags) return false
        if (templateDescription != other.templateDescription) return false
        if (templateName != other.templateName) return false
        if (templateType != other.templateType) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.TemplateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the message template. This value isn't included in a TemplateResponse object. To retrieve the ARN of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the ARN for.
         */
        public var arn: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the message template was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The JSON object that specifies the default values that are used for message variables in the message template. This object isn't included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.
         */
        public var defaultSubstitutions: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the message template was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * A map of key-value pairs that identifies the tags that are associated with the message template. This object isn't included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.
         */
        public var tags: Map<String, String>? = null
        /**
         * The custom description of the message template. This value isn't included in a TemplateResponse object. To retrieve the description of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the description for.
         */
        public var templateDescription: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and VOICE.
         */
        public var templateType: aws.sdk.kotlin.services.pinpoint.model.TemplateType? = null
        /**
         * The unique identifier, as an integer, for the active version of the message template.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.TemplateResponse) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.defaultSubstitutions = x.defaultSubstitutions
            this.lastModifiedDate = x.lastModifiedDate
            this.tags = x.tags
            this.templateDescription = x.templateDescription
            this.templateName = x.templateName
            this.templateType = x.templateType
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.TemplateResponse = TemplateResponse(this)
    }
}
