// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for an SMS activity in a journey. This type of activity sends a text message to participants.
 */
public class SmsMessageActivity private constructor(builder: Builder) {
    /**
     * Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.
     */
    public val messageConfig: aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage? = builder.messageConfig
    /**
     * The unique identifier for the next activity to perform, after the message is sent.
     */
    public val nextActivity: kotlin.String? = builder.nextActivity
    /**
     * The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link>Template Versions resource.
     *
     * If you don't specify a value for this property, Amazon Pinpoint uses the *active version* of the template. The *active version* is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
     */
    public val templateVersion: kotlin.String? = builder.templateVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SmsMessageActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsMessageActivity(")
        append("messageConfig=$messageConfig,")
        append("nextActivity=$nextActivity,")
        append("templateName=$templateName,")
        append("templateVersion=$templateVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = messageConfig?.hashCode() ?: 0
        result = 31 * result + (nextActivity?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsMessageActivity

        if (messageConfig != other.messageConfig) return false
        if (nextActivity != other.nextActivity) return false
        if (templateName != other.templateName) return false
        if (templateVersion != other.templateVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SmsMessageActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the sender ID and message type for an SMS message that's sent to participants in a journey.
         */
        public var messageConfig: aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage? = null
        /**
         * The unique identifier for the next activity to perform, after the message is sent.
         */
        public var nextActivity: kotlin.String? = null
        /**
         * The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link>Template Versions resource.
         *
         * If you don't specify a value for this property, Amazon Pinpoint uses the *active version* of the template. The *active version* is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
         */
        public var templateVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SmsMessageActivity) : this() {
            this.messageConfig = x.messageConfig
            this.nextActivity = x.nextActivity
            this.templateName = x.templateName
            this.templateVersion = x.templateVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SmsMessageActivity = SmsMessageActivity(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage] inside the given [block]
         */
        public fun messageConfig(block: aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage.Builder.() -> kotlin.Unit) {
            this.messageConfig = aws.sdk.kotlin.services.pinpoint.model.JourneySmsMessage.invoke(block)
        }
    }
}
