// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the default settings for a one-time SMS message that's sent directly to an endpoint.
 */
public class SmsMessage private constructor(builder: Builder) {
    /**
     * The body of the SMS message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The SMS program name that you provided to AWS Support when you requested your dedicated number.
     */
    public val keyword: kotlin.String? = builder.keyword
    /**
     * This field is reserved for future use.
     */
    public val mediaUrl: kotlin.String? = builder.mediaUrl
    /**
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).
     */
    public val messageType: aws.sdk.kotlin.services.pinpoint.model.MessageType? = builder.messageType
    /**
     * The number to send the SMS message from. This value should be one of the dedicated long or short codes that's assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint assigns a random long code to the SMS message and sends the message from that code.
     */
    public val originationNumber: kotlin.String? = builder.originationNumber
    /**
     * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region.
     */
    public val senderId: kotlin.String? = builder.senderId
    /**
     * The message variables to use in the SMS message. You can override the default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The template ID received from the regulatory body for sending SMS in your country.
     */
    public val templateId: kotlin.String? = builder.templateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SmsMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsMessage(")
        append("body=$body,")
        append("entityId=$entityId,")
        append("keyword=$keyword,")
        append("mediaUrl=$mediaUrl,")
        append("messageType=$messageType,")
        append("originationNumber=$originationNumber,")
        append("senderId=$senderId,")
        append("substitutions=$substitutions,")
        append("templateId=$templateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (keyword?.hashCode() ?: 0)
        result = 31 * result + (mediaUrl?.hashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (originationNumber?.hashCode() ?: 0)
        result = 31 * result + (senderId?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsMessage

        if (body != other.body) return false
        if (entityId != other.entityId) return false
        if (keyword != other.keyword) return false
        if (mediaUrl != other.mediaUrl) return false
        if (messageType != other.messageType) return false
        if (originationNumber != other.originationNumber) return false
        if (senderId != other.senderId) return false
        if (substitutions != other.substitutions) return false
        if (templateId != other.templateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SmsMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The body of the SMS message.
         */
        public var body: kotlin.String? = null
        /**
         * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
         */
        public var entityId: kotlin.String? = null
        /**
         * The SMS program name that you provided to AWS Support when you requested your dedicated number.
         */
        public var keyword: kotlin.String? = null
        /**
         * This field is reserved for future use.
         */
        public var mediaUrl: kotlin.String? = null
        /**
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing messages).
         */
        public var messageType: aws.sdk.kotlin.services.pinpoint.model.MessageType? = null
        /**
         * The number to send the SMS message from. This value should be one of the dedicated long or short codes that's assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint assigns a random long code to the SMS message and sends the message from that code.
         */
        public var originationNumber: kotlin.String? = null
        /**
         * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by country or region.
         */
        public var senderId: kotlin.String? = null
        /**
         * The message variables to use in the SMS message. You can override the default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The template ID received from the regulatory body for sending SMS in your country.
         */
        public var templateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SmsMessage) : this() {
            this.body = x.body
            this.entityId = x.entityId
            this.keyword = x.keyword
            this.mediaUrl = x.mediaUrl
            this.messageType = x.messageType
            this.originationNumber = x.originationNumber
            this.senderId = x.senderId
            this.substitutions = x.substitutions
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SmsMessage = SmsMessage(this)
    }
}
