// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about which users and endpoints a message was sent to.
 */
public class SendUsersMessageResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that was used to send the message.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The unique identifier that was assigned to the message request.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it provides an EndpointMessageResult object.
     */
    public val result: Map<String, Map<String, EndpointMessageResult>>? = builder.result

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendUsersMessageResponse(")
        append("applicationId=$applicationId,")
        append("requestId=$requestId,")
        append("result=$result")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendUsersMessageResponse

        if (applicationId != other.applicationId) return false
        if (requestId != other.requestId) return false
        if (result != other.result) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that was used to send the message.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The unique identifier that was assigned to the message request.
         */
        public var requestId: kotlin.String? = null
        /**
         * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it provides an EndpointMessageResult object.
         */
        public var result: Map<String, Map<String, EndpointMessageResult>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageResponse) : this() {
            this.applicationId = x.applicationId
            this.requestId = x.requestId
            this.result = x.result
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.SendUsersMessageResponse = SendUsersMessageResponse(this)
    }
}
