// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the schedule settings for a campaign.
 */
public class Schedule private constructor(builder: Builder) {
    /**
     * The scheduled time, in ISO 8601 format, when the campaign ended or will end.
     */
    public val endTime: kotlin.String? = builder.endTime
    /**
     * The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
     */
    public val eventFilter: aws.sdk.kotlin.services.pinpoint.model.CampaignEventFilter? = builder.eventFilter
    /**
     * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
     */
    public val frequency: aws.sdk.kotlin.services.pinpoint.model.Frequency? = builder.frequency
    /**
     * Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.
     */
    public val isLocalTime: kotlin.Boolean = builder.isLocalTime
    /**
     * The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:
     * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.
     * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.
     *
     * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.
     */
    public val quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = builder.quietTime
    /**
     * The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.
     */
    public val startTime: kotlin.String? = builder.startTime
    /**
     * The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.Schedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Schedule(")
        append("endTime=$endTime,")
        append("eventFilter=$eventFilter,")
        append("frequency=$frequency,")
        append("isLocalTime=$isLocalTime,")
        append("quietTime=$quietTime,")
        append("startTime=$startTime,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (eventFilter?.hashCode() ?: 0)
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (isLocalTime.hashCode())
        result = 31 * result + (quietTime?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Schedule

        if (endTime != other.endTime) return false
        if (eventFilter != other.eventFilter) return false
        if (frequency != other.frequency) return false
        if (isLocalTime != other.isLocalTime) return false
        if (quietTime != other.quietTime) return false
        if (startTime != other.startTime) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.Schedule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The scheduled time, in ISO 8601 format, when the campaign ended or will end.
         */
        public var endTime: kotlin.String? = null
        /**
         * The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
         */
        public var eventFilter: aws.sdk.kotlin.services.pinpoint.model.CampaignEventFilter? = null
        /**
         * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
         */
        public var frequency: aws.sdk.kotlin.services.pinpoint.model.Frequency? = null
        /**
         * Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the schedule on each recipient's local time, set this value to true.
         */
        public var isLocalTime: kotlin.Boolean = false
        /**
         * The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:
         * + The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * + The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.
         * + The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.
         *
         * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.
         */
        public var quietTime: aws.sdk.kotlin.services.pinpoint.model.QuietTime? = null
        /**
         * The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.
         */
        public var startTime: kotlin.String? = null
        /**
         * The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.Schedule) : this() {
            this.endTime = x.endTime
            this.eventFilter = x.eventFilter
            this.frequency = x.frequency
            this.isLocalTime = x.isLocalTime
            this.quietTime = x.quietTime
            this.startTime = x.startTime
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.Schedule = Schedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.CampaignEventFilter] inside the given [block]
         */
        public fun eventFilter(block: aws.sdk.kotlin.services.pinpoint.model.CampaignEventFilter.Builder.() -> kotlin.Unit) {
            this.eventFilter = aws.sdk.kotlin.services.pinpoint.model.CampaignEventFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.QuietTime] inside the given [block]
         */
        public fun quietTime(block: aws.sdk.kotlin.services.pinpoint.model.QuietTime.Builder.() -> kotlin.Unit) {
            this.quietTime = aws.sdk.kotlin.services.pinpoint.model.QuietTime.invoke(block)
        }
    }
}
