// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the settings for a multivariate split activity in a journey. This type of activity sends participants down one of as many as five paths (including a default *Else* path) in a journey, based on conditions that you specify.
 *
 * To create multivariate split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see [Integrating Amazon Pinpoint with your application](https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html) in the *Amazon Pinpoint Developer Guide*.
 */
public class MultiConditionalSplitActivity private constructor(builder: Builder) {
    /**
     * The paths for the activity, including the conditions for entering each path and the activity to perform for each path.
     */
    public val branches: List<MultiConditionalBranch>? = builder.branches
    /**
     * The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.
     */
    public val defaultActivity: kotlin.String? = builder.defaultActivity
    /**
     * The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.
     */
    public val evaluationWaitTime: aws.sdk.kotlin.services.pinpoint.model.WaitTime? = builder.evaluationWaitTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.MultiConditionalSplitActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MultiConditionalSplitActivity(")
        append("branches=$branches,")
        append("defaultActivity=$defaultActivity,")
        append("evaluationWaitTime=$evaluationWaitTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branches?.hashCode() ?: 0
        result = 31 * result + (defaultActivity?.hashCode() ?: 0)
        result = 31 * result + (evaluationWaitTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MultiConditionalSplitActivity

        if (branches != other.branches) return false
        if (defaultActivity != other.defaultActivity) return false
        if (evaluationWaitTime != other.evaluationWaitTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.MultiConditionalSplitActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The paths for the activity, including the conditions for entering each path and the activity to perform for each path.
         */
        public var branches: List<MultiConditionalBranch>? = null
        /**
         * The unique identifier for the activity to perform for participants who don't meet any of the conditions specified for other paths in the activity.
         */
        public var defaultActivity: kotlin.String? = null
        /**
         * The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.
         */
        public var evaluationWaitTime: aws.sdk.kotlin.services.pinpoint.model.WaitTime? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.MultiConditionalSplitActivity) : this() {
            this.branches = x.branches
            this.defaultActivity = x.defaultActivity
            this.evaluationWaitTime = x.evaluationWaitTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.MultiConditionalSplitActivity = MultiConditionalSplitActivity(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.WaitTime] inside the given [block]
         */
        public fun evaluationWaitTime(block: aws.sdk.kotlin.services.pinpoint.model.WaitTime.Builder.() -> kotlin.Unit) {
            this.evaluationWaitTime = aws.sdk.kotlin.services.pinpoint.model.WaitTime.invoke(block)
        }
    }
}
