// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the configuration and other settings for a message.
 */
public class MessageRequest private constructor(builder: Builder) {
    /**
     * A map of key-value pairs, where each key is an address and each value is an [AddressConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration) object. An address can be a push notification token, a phone number, or an email address. You can use an [AddressConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration) object to tailor the message for an address by specifying settings such as content overrides and message variables.
     */
    public val addresses: Map<String, AddressConfiguration>? = builder.addresses
    /**
     * A map of custom attributes to attach to the message. For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.
     */
    public val context: Map<String, String>? = builder.context
    /**
     * A map of key-value pairs, where each key is an endpoint ID and each value is an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object. You can use an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object to tailor the message for an endpoint by specifying settings such as content overrides and message variables.
     */
    public val endpoints: Map<String, EndpointSendConfiguration>? = builder.endpoints
    /**
     * The settings and content for the default message and any default messages that you defined for specific channels.
     */
    public val messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration? = builder.messageConfiguration
    /**
     * The message template to use for the message.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * The unique identifier for tracing the message. This identifier is visible to message recipients.
     */
    public val traceId: kotlin.String? = builder.traceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.MessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageRequest(")
        append("addresses=$addresses,")
        append("context=$context,")
        append("endpoints=$endpoints,")
        append("messageConfiguration=$messageConfiguration,")
        append("templateConfiguration=$templateConfiguration,")
        append("traceId=$traceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (messageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (traceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageRequest

        if (addresses != other.addresses) return false
        if (context != other.context) return false
        if (endpoints != other.endpoints) return false
        if (messageConfiguration != other.messageConfiguration) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (traceId != other.traceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.MessageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of key-value pairs, where each key is an address and each value is an [AddressConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration) object. An address can be a push notification token, a phone number, or an email address. You can use an [AddressConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration) object to tailor the message for an address by specifying settings such as content overrides and message variables.
         */
        public var addresses: Map<String, AddressConfiguration>? = null
        /**
         * A map of custom attributes to attach to the message. For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.
         */
        public var context: Map<String, String>? = null
        /**
         * A map of key-value pairs, where each key is an endpoint ID and each value is an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object. You can use an [EndpointSendConfiguration](https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration) object to tailor the message for an endpoint by specifying settings such as content overrides and message variables.
         */
        public var endpoints: Map<String, EndpointSendConfiguration>? = null
        /**
         * The settings and content for the default message and any default messages that you defined for specific channels.
         */
        public var messageConfiguration: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration? = null
        /**
         * The message template to use for the message.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration? = null
        /**
         * The unique identifier for tracing the message. This identifier is visible to message recipients.
         */
        public var traceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.MessageRequest) : this() {
            this.addresses = x.addresses
            this.context = x.context
            this.endpoints = x.endpoints
            this.messageConfiguration = x.messageConfiguration
            this.templateConfiguration = x.templateConfiguration
            this.traceId = x.traceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.MessageRequest = MessageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration] inside the given [block]
         */
        public fun messageConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration.Builder.() -> kotlin.Unit) {
            this.messageConfiguration = aws.sdk.kotlin.services.pinpoint.model.DirectMessageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.pinpoint.model.TemplateConfiguration.invoke(block)
        }
    }
}
