// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the content and settings for a push notification that's sent to recipients of a campaign.
 */
public class Message private constructor(builder: Builder) {
    /**
     * The action to occur if a recipient taps the push notification. Valid values are:
     * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
     * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.
     * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
     */
    public val action: aws.sdk.kotlin.services.pinpoint.model.Action? = builder.action
    /**
     * The body of the notification message. The maximum number of characters is 200.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The URL of the image to display as the push-notification icon, such as the icon for the app.
     */
    public val imageIconUrl: kotlin.String? = builder.imageIconUrl
    /**
     * The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.
     */
    public val imageSmallIconUrl: kotlin.String? = builder.imageSmallIconUrl
    /**
     * The URL of an image to display in the push notification.
     */
    public val imageUrl: kotlin.String? = builder.imageUrl
    /**
     * The JSON payload to use for a silent push notification.
     */
    public val jsonBody: kotlin.String? = builder.jsonBody
    /**
     * The URL of the image or video to display in the push notification.
     */
    public val mediaUrl: kotlin.String? = builder.mediaUrl
    /**
     * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
     */
    public val rawContent: kotlin.String? = builder.rawContent
    /**
     * Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.
     */
    public val silentPush: kotlin.Boolean = builder.silentPush
    /**
     * The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
     *
     * This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
     */
    public val timeToLive: kotlin.Int = builder.timeToLive
    /**
     * The title to display above the notification message on a recipient's device.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.Message = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Message(")
        append("action=$action,")
        append("body=$body,")
        append("imageIconUrl=$imageIconUrl,")
        append("imageSmallIconUrl=$imageSmallIconUrl,")
        append("imageUrl=$imageUrl,")
        append("jsonBody=$jsonBody,")
        append("mediaUrl=$mediaUrl,")
        append("rawContent=$rawContent,")
        append("silentPush=$silentPush,")
        append("timeToLive=$timeToLive,")
        append("title=$title,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (imageIconUrl?.hashCode() ?: 0)
        result = 31 * result + (imageSmallIconUrl?.hashCode() ?: 0)
        result = 31 * result + (imageUrl?.hashCode() ?: 0)
        result = 31 * result + (jsonBody?.hashCode() ?: 0)
        result = 31 * result + (mediaUrl?.hashCode() ?: 0)
        result = 31 * result + (rawContent?.hashCode() ?: 0)
        result = 31 * result + (silentPush.hashCode())
        result = 31 * result + (timeToLive)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Message

        if (action != other.action) return false
        if (body != other.body) return false
        if (imageIconUrl != other.imageIconUrl) return false
        if (imageSmallIconUrl != other.imageSmallIconUrl) return false
        if (imageUrl != other.imageUrl) return false
        if (jsonBody != other.jsonBody) return false
        if (mediaUrl != other.mediaUrl) return false
        if (rawContent != other.rawContent) return false
        if (silentPush != other.silentPush) return false
        if (timeToLive != other.timeToLive) return false
        if (title != other.title) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.Message = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to occur if a recipient taps the push notification. Valid values are:
         * + OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.
         * + DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.
         * + URL - The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.
         */
        public var action: aws.sdk.kotlin.services.pinpoint.model.Action? = null
        /**
         * The body of the notification message. The maximum number of characters is 200.
         */
        public var body: kotlin.String? = null
        /**
         * The URL of the image to display as the push-notification icon, such as the icon for the app.
         */
        public var imageIconUrl: kotlin.String? = null
        /**
         * The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.
         */
        public var imageSmallIconUrl: kotlin.String? = null
        /**
         * The URL of an image to display in the push notification.
         */
        public var imageUrl: kotlin.String? = null
        /**
         * The JSON payload to use for a silent push notification.
         */
        public var jsonBody: kotlin.String? = null
        /**
         * The URL of the image or video to display in the push notification.
         */
        public var mediaUrl: kotlin.String? = null
        /**
         * The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.
         */
        public var rawContent: kotlin.String? = null
        /**
         * Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device. Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.
         */
        public var silentPush: kotlin.Boolean = false
        /**
         * The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it's sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
         *
         * This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
         */
        public var timeToLive: kotlin.Int = 0
        /**
         * The title to display above the notification message on a recipient's device.
         */
        public var title: kotlin.String? = null
        /**
         * The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.Message) : this() {
            this.action = x.action
            this.body = x.body
            this.imageIconUrl = x.imageIconUrl
            this.imageSmallIconUrl = x.imageSmallIconUrl
            this.imageUrl = x.imageUrl
            this.jsonBody = x.jsonBody
            this.mediaUrl = x.mediaUrl
            this.rawContent = x.rawContent
            this.silentPush = x.silentPush
            this.timeToLive = x.timeToLive
            this.title = x.title
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.Message = Message(this)
    }
}
