// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey, and provides information about that query.
 */
public class JourneyExecutionMetricsResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the metric applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The unique identifier for the journey that the metric applies to.
     */
    public val journeyId: kotlin.String? = builder.journeyId
    /**
     * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the data for the metric.
     */
    public val lastEvaluatedTime: kotlin.String? = builder.lastEvaluatedTime
    /**
     * A JSON object that contains the results of the query. For information about the structure and contents of the results, see the [Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html).
     */
    public val metrics: Map<String, String>? = builder.metrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.JourneyExecutionMetricsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JourneyExecutionMetricsResponse(")
        append("applicationId=$applicationId,")
        append("journeyId=$journeyId,")
        append("lastEvaluatedTime=$lastEvaluatedTime,")
        append("metrics=$metrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (journeyId?.hashCode() ?: 0)
        result = 31 * result + (lastEvaluatedTime?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JourneyExecutionMetricsResponse

        if (applicationId != other.applicationId) return false
        if (journeyId != other.journeyId) return false
        if (lastEvaluatedTime != other.lastEvaluatedTime) return false
        if (metrics != other.metrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.JourneyExecutionMetricsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that the metric applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The unique identifier for the journey that the metric applies to.
         */
        public var journeyId: kotlin.String? = null
        /**
         * The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the data for the metric.
         */
        public var lastEvaluatedTime: kotlin.String? = null
        /**
         * A JSON object that contains the results of the query. For information about the structure and contents of the results, see the [Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html).
         */
        public var metrics: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.JourneyExecutionMetricsResponse) : this() {
            this.applicationId = x.applicationId
            this.journeyId = x.journeyId
            this.lastEvaluatedTime = x.lastEvaluatedTime
            this.metrics = x.metrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.JourneyExecutionMetricsResponse = JourneyExecutionMetricsResponse(this)
    }
}
