// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose delivery stream.
 */
public class EventStream private constructor(builder: Builder) {
    /**
     * The unique identifier for the application to publish event data for.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream to publish event data to.
     *
     * For a Kinesis data stream, the ARN format is: arn:aws:kinesis:<replaceable>region:<replaceable>account-id:stream/<replaceable>stream_name
     *
     * For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:<replaceable>region:<replaceable>account-id:deliverystream/<replaceable>stream_name
     */
    public val destinationStreamArn: kotlin.String? = builder.destinationStreamArn
    /**
     * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The date, in ISO 8601 format, when the event stream was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The IAM user who last modified the event stream.
     */
    public val lastUpdatedBy: kotlin.String? = builder.lastUpdatedBy
    /**
     * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the stream in your AWS account.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EventStream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventStream(")
        append("applicationId=$applicationId,")
        append("destinationStreamArn=$destinationStreamArn,")
        append("externalId=$externalId,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (destinationStreamArn?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventStream

        if (applicationId != other.applicationId) return false
        if (destinationStreamArn != other.destinationStreamArn) return false
        if (externalId != other.externalId) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EventStream = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application to publish event data for.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream to publish event data to.
         *
         * For a Kinesis data stream, the ARN format is: arn:aws:kinesis:<replaceable>region:<replaceable>account-id:stream/<replaceable>stream_name
         *
         * For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:<replaceable>region:<replaceable>account-id:deliverystream/<replaceable>stream_name
         */
        public var destinationStreamArn: kotlin.String? = null
        /**
         * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
         */
        public var externalId: kotlin.String? = null
        /**
         * The date, in ISO 8601 format, when the event stream was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The IAM user who last modified the event stream.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the stream in your AWS account.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EventStream) : this() {
            this.applicationId = x.applicationId
            this.destinationStreamArn = x.destinationStreamArn
            this.externalId = x.externalId
            this.lastModifiedDate = x.lastModifiedDate
            this.lastUpdatedBy = x.lastUpdatedBy
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EventStream = EventStream(this)
    }
}
