// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the content, including message variables and attributes, to use in a message that's sent directly to an endpoint.
 */
public class EndpointSendConfiguration private constructor(builder: Builder) {
    /**
     * The body of the message. If specified, this value overrides the default message body.
     */
    public val bodyOverride: kotlin.String? = builder.bodyOverride
    /**
     * A map of custom attributes to attach to the message for the address. Attribute names are case sensitive.
     *
     * For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.
     */
    public val context: Map<String, String>? = builder.context
    /**
     * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all other values for the message.
     */
    public val rawContent: kotlin.String? = builder.rawContent
    /**
     * A map of the message variables to merge with the variables specified for the default message (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions
    /**
     * The title or subject line of the message. If specified, this value overrides the default message title or subject line.
     */
    public val titleOverride: kotlin.String? = builder.titleOverride

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EndpointSendConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointSendConfiguration(")
        append("bodyOverride=$bodyOverride,")
        append("context=$context,")
        append("rawContent=$rawContent,")
        append("substitutions=$substitutions,")
        append("titleOverride=$titleOverride")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bodyOverride?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (rawContent?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        result = 31 * result + (titleOverride?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointSendConfiguration

        if (bodyOverride != other.bodyOverride) return false
        if (context != other.context) return false
        if (rawContent != other.rawContent) return false
        if (substitutions != other.substitutions) return false
        if (titleOverride != other.titleOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EndpointSendConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The body of the message. If specified, this value overrides the default message body.
         */
        public var bodyOverride: kotlin.String? = null
        /**
         * A map of custom attributes to attach to the message for the address. Attribute names are case sensitive.
         *
         * For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.
         */
        public var context: Map<String, String>? = null
        /**
         * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all other values for the message.
         */
        public var rawContent: kotlin.String? = null
        /**
         * A map of the message variables to merge with the variables specified for the default message (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other variables.
         */
        public var substitutions: Map<String, List<String>>? = null
        /**
         * The title or subject line of the message. If specified, this value overrides the default message title or subject line.
         */
        public var titleOverride: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EndpointSendConfiguration) : this() {
            this.bodyOverride = x.bodyOverride
            this.context = x.context
            this.rawContent = x.rawContent
            this.substitutions = x.substitutions
            this.titleOverride = x.titleOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EndpointSendConfiguration = EndpointSendConfiguration(this)
    }
}
