// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies the default settings and content for a one-time email message that's sent directly to an endpoint.
 */
public class EmailMessage private constructor(builder: Builder) {
    /**
     * The body of the email message.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The email address to forward bounces and complaints to, if feedback forwarding is enabled.
     */
    public val feedbackForwardingAddress: kotlin.String? = builder.feedbackForwardingAddress
    /**
     * The verified email address to send the email message from. The default value is the FromAddress specified for the email channel.
     */
    public val fromAddress: kotlin.String? = builder.fromAddress
    /**
     * The email message, represented as a raw MIME message.
     */
    public val rawEmail: aws.sdk.kotlin.services.pinpoint.model.RawEmail? = builder.rawEmail
    /**
     * The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses
    /**
     * The email message, composed of a subject, a text part, and an HTML part.
     */
    public val simpleEmail: aws.sdk.kotlin.services.pinpoint.model.SimpleEmail? = builder.simpleEmail
    /**
     * The default message variables to use in the email message. You can override the default variables with individual address variables.
     */
    public val substitutions: Map<String, List<String>>? = builder.substitutions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.EmailMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailMessage(")
        append("body=$body,")
        append("feedbackForwardingAddress=$feedbackForwardingAddress,")
        append("fromAddress=$fromAddress,")
        append("rawEmail=$rawEmail,")
        append("replyToAddresses=$replyToAddresses,")
        append("simpleEmail=$simpleEmail,")
        append("substitutions=$substitutions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (feedbackForwardingAddress?.hashCode() ?: 0)
        result = 31 * result + (fromAddress?.hashCode() ?: 0)
        result = 31 * result + (rawEmail?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        result = 31 * result + (simpleEmail?.hashCode() ?: 0)
        result = 31 * result + (substitutions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailMessage

        if (body != other.body) return false
        if (feedbackForwardingAddress != other.feedbackForwardingAddress) return false
        if (fromAddress != other.fromAddress) return false
        if (rawEmail != other.rawEmail) return false
        if (replyToAddresses != other.replyToAddresses) return false
        if (simpleEmail != other.simpleEmail) return false
        if (substitutions != other.substitutions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.EmailMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The body of the email message.
         */
        public var body: kotlin.String? = null
        /**
         * The email address to forward bounces and complaints to, if feedback forwarding is enabled.
         */
        public var feedbackForwardingAddress: kotlin.String? = null
        /**
         * The verified email address to send the email message from. The default value is the FromAddress specified for the email channel.
         */
        public var fromAddress: kotlin.String? = null
        /**
         * The email message, represented as a raw MIME message.
         */
        public var rawEmail: aws.sdk.kotlin.services.pinpoint.model.RawEmail? = null
        /**
         * The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null
        /**
         * The email message, composed of a subject, a text part, and an HTML part.
         */
        public var simpleEmail: aws.sdk.kotlin.services.pinpoint.model.SimpleEmail? = null
        /**
         * The default message variables to use in the email message. You can override the default variables with individual address variables.
         */
        public var substitutions: Map<String, List<String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.EmailMessage) : this() {
            this.body = x.body
            this.feedbackForwardingAddress = x.feedbackForwardingAddress
            this.fromAddress = x.fromAddress
            this.rawEmail = x.rawEmail
            this.replyToAddresses = x.replyToAddresses
            this.simpleEmail = x.simpleEmail
            this.substitutions = x.substitutions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.EmailMessage = EmailMessage(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.RawEmail] inside the given [block]
         */
        public fun rawEmail(block: aws.sdk.kotlin.services.pinpoint.model.RawEmail.Builder.() -> kotlin.Unit) {
            this.rawEmail = aws.sdk.kotlin.services.pinpoint.model.RawEmail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpoint.model.SimpleEmail] inside the given [block]
         */
        public fun simpleEmail(block: aws.sdk.kotlin.services.pinpoint.model.SimpleEmail.Builder.() -> kotlin.Unit) {
            this.simpleEmail = aws.sdk.kotlin.services.pinpoint.model.SimpleEmail.invoke(block)
        }
    }
}
