// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign.
 */
public class CampaignHook private constructor(builder: Builder) {
    /**
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.
     */
    public val lambdaFunctionName: kotlin.String? = builder.lambdaFunctionName
    /**
     * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
     * + FILTER - Invoke the function to customize the segment that's used by a campaign.
     * + DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
     */
    public val mode: aws.sdk.kotlin.services.pinpoint.model.Mode? = builder.mode
    /**
     * The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
     */
    public val webUrl: kotlin.String? = builder.webUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.CampaignHook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignHook(")
        append("lambdaFunctionName=$lambdaFunctionName,")
        append("mode=$mode,")
        append("webUrl=$webUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lambdaFunctionName?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (webUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignHook

        if (lambdaFunctionName != other.lambdaFunctionName) return false
        if (mode != other.mode) return false
        if (webUrl != other.webUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.CampaignHook = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.
         */
        public var lambdaFunctionName: kotlin.String? = null
        /**
         * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
         * + FILTER - Invoke the function to customize the segment that's used by a campaign.
         * + DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
         */
        public var mode: aws.sdk.kotlin.services.pinpoint.model.Mode? = null
        /**
         * The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
         */
        public var webUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.CampaignHook) : this() {
            this.lambdaFunctionName = x.lambdaFunctionName
            this.mode = x.mode
            this.webUrl = x.webUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.CampaignHook = CampaignHook(this)
    }
}
