// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint.model



/**
 * Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.
 */
public class ApnsVoipChannelResponse private constructor(builder: Builder) {
    /**
     * The unique identifier for the application that the APNs VoIP channel applies to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The date and time when the APNs VoIP channel was enabled.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.
     */
    public val defaultAuthenticationMethod: kotlin.String? = builder.defaultAuthenticationMethod
    /**
     * Specifies whether the APNs VoIP channel is enabled for the application.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * (Not used) This property is retained only for backward compatibility.
     */
    public val hasCredential: kotlin.Boolean = builder.hasCredential
    /**
     * Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.
     */
    public val hasTokenKey: kotlin.Boolean = builder.hasTokenKey
    /**
     * (Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies whether the APNs VoIP channel is archived.
     */
    public val isArchived: kotlin.Boolean = builder.isArchived
    /**
     * The user who last modified the APNs VoIP channel.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time when the APNs VoIP channel was last modified.
     */
    public val lastModifiedDate: kotlin.String? = builder.lastModifiedDate
    /**
     * The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The current version of the APNs VoIP channel.
     */
    public val version: kotlin.Int = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApnsVoipChannelResponse(")
        append("applicationId=$applicationId,")
        append("creationDate=$creationDate,")
        append("defaultAuthenticationMethod=$defaultAuthenticationMethod,")
        append("enabled=$enabled,")
        append("hasCredential=$hasCredential,")
        append("hasTokenKey=$hasTokenKey,")
        append("id=$id,")
        append("isArchived=$isArchived,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("platform=$platform,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (defaultAuthenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (hasCredential.hashCode())
        result = 31 * result + (hasTokenKey.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isArchived.hashCode())
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (version)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApnsVoipChannelResponse

        if (applicationId != other.applicationId) return false
        if (creationDate != other.creationDate) return false
        if (defaultAuthenticationMethod != other.defaultAuthenticationMethod) return false
        if (enabled != other.enabled) return false
        if (hasCredential != other.hasCredential) return false
        if (hasTokenKey != other.hasTokenKey) return false
        if (id != other.id) return false
        if (isArchived != other.isArchived) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (platform != other.platform) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipChannelResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the application that the APNs VoIP channel applies to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The date and time when the APNs VoIP channel was enabled.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.
         */
        public var defaultAuthenticationMethod: kotlin.String? = null
        /**
         * Specifies whether the APNs VoIP channel is enabled for the application.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * (Not used) This property is retained only for backward compatibility.
         */
        public var hasCredential: kotlin.Boolean = false
        /**
         * Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.
         */
        public var hasTokenKey: kotlin.Boolean = false
        /**
         * (Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether the APNs VoIP channel is archived.
         */
        public var isArchived: kotlin.Boolean = false
        /**
         * The user who last modified the APNs VoIP channel.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time when the APNs VoIP channel was last modified.
         */
        public var lastModifiedDate: kotlin.String? = null
        /**
         * The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.
         */
        public var platform: kotlin.String? = null
        /**
         * The current version of the APNs VoIP channel.
         */
        public var version: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpoint.model.ApnsVoipChannelResponse) : this() {
            this.applicationId = x.applicationId
            this.creationDate = x.creationDate
            this.defaultAuthenticationMethod = x.defaultAuthenticationMethod
            this.enabled = x.enabled
            this.hasCredential = x.hasCredential
            this.hasTokenKey = x.hasTokenKey
            this.id = x.id
            this.isArchived = x.isArchived
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedDate = x.lastModifiedDate
            this.platform = x.platform
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpoint.model.ApnsVoipChannelResponse = ApnsVoipChannelResponse(this)
    }
}
