// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpoint

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.pinpoint.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.pinpoint.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.pinpoint.model.*
import aws.sdk.kotlin.services.pinpoint.model.CreateAppRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateExportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateImportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.CreatePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.CreateVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteAppRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.DeletePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteUserEndpointsRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.DeleteVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAppRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetApplicationSettingsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetAppsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignActivitiesRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetCampaignsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetChannelsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.GetEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.GetExportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobRequest
import aws.sdk.kotlin.services.pinpoint.model.GetImportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetInAppMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.GetInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyDateRangeKpiRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyExecutionMetricsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.GetPushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.GetRecommenderConfigurationsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentExportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentImportJobsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSegmentsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.GetUserEndpointsRequest
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.GetVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.ListJourneysRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTemplateVersionsRequest
import aws.sdk.kotlin.services.pinpoint.model.ListTemplatesRequest
import aws.sdk.kotlin.services.pinpoint.model.PhoneNumberValidateRequest
import aws.sdk.kotlin.services.pinpoint.model.PutEventStreamRequest
import aws.sdk.kotlin.services.pinpoint.model.PutEventsRequest
import aws.sdk.kotlin.services.pinpoint.model.RemoveAttributesRequest
import aws.sdk.kotlin.services.pinpoint.model.SendMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.SendOtpMessageRequest
import aws.sdk.kotlin.services.pinpoint.model.SendUsersMessagesRequest
import aws.sdk.kotlin.services.pinpoint.model.TagResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.UntagResourceRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateAdmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateApplicationSettingsRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateBaiduChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateCampaignRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEmailTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateEndpointsBatchRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateGcmChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateInAppTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateJourneyStateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdatePushTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateRecommenderConfigurationRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSegmentRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateSmsTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateTemplateActiveVersionRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceChannelRequest
import aws.sdk.kotlin.services.pinpoint.model.UpdateVoiceTemplateRequest
import aws.sdk.kotlin.services.pinpoint.model.VerifyOtpMessageRequest
import aws.sdk.kotlin.services.pinpoint.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Pinpoint"
public const val ServiceApiVersion: String = "2016-12-01"
public const val SdkVersion: String = "0.21.1-beta"

internal class DefaultPinpointClient(override val config: PinpointClient.Config) : PinpointClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an application.
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateApp"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateAppRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateApp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializer = CreateCampaignOperationSerializer()
            deserializer = CreateCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateCampaign"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCampaignRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCampaign-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a message template for messages that are sent through the email channel.
     */
    override suspend fun createEmailTemplate(input: CreateEmailTemplateRequest): CreateEmailTemplateResponse {
        val op = SdkHttpOperation.build<CreateEmailTemplateRequest, CreateEmailTemplateResponse> {
            serializer = CreateEmailTemplateOperationSerializer()
            deserializer = CreateEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateEmailTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateEmailTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEmailTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an export job for an application.
     */
    override suspend fun createExportJob(input: CreateExportJobRequest): CreateExportJobResponse {
        val op = SdkHttpOperation.build<CreateExportJobRequest, CreateExportJobResponse> {
            serializer = CreateExportJobOperationSerializer()
            deserializer = CreateExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateExportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateExportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateExportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an import job for an application.
     */
    override suspend fun createImportJob(input: CreateImportJobRequest): CreateImportJobResponse {
        val op = SdkHttpOperation.build<CreateImportJobRequest, CreateImportJobResponse> {
            serializer = CreateImportJobOperationSerializer()
            deserializer = CreateImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateImportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateImportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateImportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new message template for messages using the in-app message channel.
     */
    override suspend fun createInAppTemplate(input: CreateInAppTemplateRequest): CreateInAppTemplateResponse {
        val op = SdkHttpOperation.build<CreateInAppTemplateRequest, CreateInAppTemplateResponse> {
            serializer = CreateInAppTemplateOperationSerializer()
            deserializer = CreateInAppTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateInAppTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateInAppTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateInAppTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a journey for an application.
     */
    override suspend fun createJourney(input: CreateJourneyRequest): CreateJourneyResponse {
        val op = SdkHttpOperation.build<CreateJourneyRequest, CreateJourneyResponse> {
            serializer = CreateJourneyOperationSerializer()
            deserializer = CreateJourneyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateJourney"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateJourneyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateJourney-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a message template for messages that are sent through a push notification channel.
     */
    override suspend fun createPushTemplate(input: CreatePushTemplateRequest): CreatePushTemplateResponse {
        val op = SdkHttpOperation.build<CreatePushTemplateRequest, CreatePushTemplateResponse> {
            serializer = CreatePushTemplateOperationSerializer()
            deserializer = CreatePushTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePushTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreatePushTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreatePushTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun createRecommenderConfiguration(input: CreateRecommenderConfigurationRequest): CreateRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<CreateRecommenderConfigurationRequest, CreateRecommenderConfigurationResponse> {
            serializer = CreateRecommenderConfigurationOperationSerializer()
            deserializer = CreateRecommenderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRecommenderConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateRecommenderConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRecommenderConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    override suspend fun createSegment(input: CreateSegmentRequest): CreateSegmentResponse {
        val op = SdkHttpOperation.build<CreateSegmentRequest, CreateSegmentResponse> {
            serializer = CreateSegmentOperationSerializer()
            deserializer = CreateSegmentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSegment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSegmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSegment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a message template for messages that are sent through the SMS channel.
     */
    override suspend fun createSmsTemplate(input: CreateSmsTemplateRequest): CreateSmsTemplateResponse {
        val op = SdkHttpOperation.build<CreateSmsTemplateRequest, CreateSmsTemplateResponse> {
            serializer = CreateSmsTemplateOperationSerializer()
            deserializer = CreateSmsTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSmsTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSmsTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSmsTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a message template for messages that are sent through the voice channel.
     */
    override suspend fun createVoiceTemplate(input: CreateVoiceTemplateRequest): CreateVoiceTemplateResponse {
        val op = SdkHttpOperation.build<CreateVoiceTemplateRequest, CreateVoiceTemplateResponse> {
            serializer = CreateVoiceTemplateOperationSerializer()
            deserializer = CreateVoiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateVoiceTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateVoiceTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateVoiceTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteAdmChannel(input: DeleteAdmChannelRequest): DeleteAdmChannelResponse {
        val op = SdkHttpOperation.build<DeleteAdmChannelRequest, DeleteAdmChannelResponse> {
            serializer = DeleteAdmChannelOperationSerializer()
            deserializer = DeleteAdmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAdmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAdmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAdmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsChannel(input: DeleteApnsChannelRequest): DeleteApnsChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsChannelRequest, DeleteApnsChannelResponse> {
            serializer = DeleteApnsChannelOperationSerializer()
            deserializer = DeleteApnsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApnsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApnsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApnsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsSandboxChannel(input: DeleteApnsSandboxChannelRequest): DeleteApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse> {
            serializer = DeleteApnsSandboxChannelOperationSerializer()
            deserializer = DeleteApnsSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApnsSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApnsSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApnsSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsVoipChannel(input: DeleteApnsVoipChannelRequest): DeleteApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse> {
            serializer = DeleteApnsVoipChannelOperationSerializer()
            deserializer = DeleteApnsVoipChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApnsVoipChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApnsVoipChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApnsVoipChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteApnsVoipSandboxChannel(input: DeleteApnsVoipSandboxChannelRequest): DeleteApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse> {
            serializer = DeleteApnsVoipSandboxChannelOperationSerializer()
            deserializer = DeleteApnsVoipSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApnsVoipSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteApnsVoipSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApnsVoipSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an application.
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApp"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAppRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteApp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteBaiduChannel(input: DeleteBaiduChannelRequest): DeleteBaiduChannelResponse {
        val op = SdkHttpOperation.build<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse> {
            serializer = DeleteBaiduChannelOperationSerializer()
            deserializer = DeleteBaiduChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBaiduChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBaiduChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBaiduChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a campaign from an application.
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializer = DeleteCampaignOperationSerializer()
            deserializer = DeleteCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCampaign"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCampaignRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCampaign-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the email channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteEmailChannel(input: DeleteEmailChannelRequest): DeleteEmailChannelResponse {
        val op = SdkHttpOperation.build<DeleteEmailChannelRequest, DeleteEmailChannelResponse> {
            serializer = DeleteEmailChannelOperationSerializer()
            deserializer = DeleteEmailChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEmailChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEmailChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEmailChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a message template for messages that were sent through the email channel.
     */
    override suspend fun deleteEmailTemplate(input: DeleteEmailTemplateRequest): DeleteEmailTemplateResponse {
        val op = SdkHttpOperation.build<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse> {
            serializer = DeleteEmailTemplateOperationSerializer()
            deserializer = DeleteEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteEmailTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEmailTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEmailTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an endpoint from an application.
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteEndpoint"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEndpointRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the event stream for an application.
     */
    override suspend fun deleteEventStream(input: DeleteEventStreamRequest): DeleteEventStreamResponse {
        val op = SdkHttpOperation.build<DeleteEventStreamRequest, DeleteEventStreamResponse> {
            serializer = DeleteEventStreamOperationSerializer()
            deserializer = DeleteEventStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventStream"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEventStreamRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEventStream-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteGcmChannel(input: DeleteGcmChannelRequest): DeleteGcmChannelResponse {
        val op = SdkHttpOperation.build<DeleteGcmChannelRequest, DeleteGcmChannelResponse> {
            serializer = DeleteGcmChannelOperationSerializer()
            deserializer = DeleteGcmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGcmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteGcmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteGcmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a message template for messages sent using the in-app message channel.
     */
    override suspend fun deleteInAppTemplate(input: DeleteInAppTemplateRequest): DeleteInAppTemplateResponse {
        val op = SdkHttpOperation.build<DeleteInAppTemplateRequest, DeleteInAppTemplateResponse> {
            serializer = DeleteInAppTemplateOperationSerializer()
            deserializer = DeleteInAppTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteInAppTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteInAppTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteInAppTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a journey from an application.
     */
    override suspend fun deleteJourney(input: DeleteJourneyRequest): DeleteJourneyResponse {
        val op = SdkHttpOperation.build<DeleteJourneyRequest, DeleteJourneyResponse> {
            serializer = DeleteJourneyOperationSerializer()
            deserializer = DeleteJourneyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJourney"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteJourneyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteJourney-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a message template for messages that were sent through a push notification channel.
     */
    override suspend fun deletePushTemplate(input: DeletePushTemplateRequest): DeletePushTemplateResponse {
        val op = SdkHttpOperation.build<DeletePushTemplateRequest, DeletePushTemplateResponse> {
            serializer = DeletePushTemplateOperationSerializer()
            deserializer = DeletePushTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeletePushTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeletePushTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeletePushTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun deleteRecommenderConfiguration(input: DeleteRecommenderConfigurationRequest): DeleteRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteRecommenderConfigurationRequest, DeleteRecommenderConfigurationResponse> {
            serializer = DeleteRecommenderConfigurationOperationSerializer()
            deserializer = DeleteRecommenderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRecommenderConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteRecommenderConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRecommenderConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a segment from an application.
     */
    override suspend fun deleteSegment(input: DeleteSegmentRequest): DeleteSegmentResponse {
        val op = SdkHttpOperation.build<DeleteSegmentRequest, DeleteSegmentResponse> {
            serializer = DeleteSegmentOperationSerializer()
            deserializer = DeleteSegmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSegment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSegmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSegment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteSmsChannel(input: DeleteSmsChannelRequest): DeleteSmsChannelResponse {
        val op = SdkHttpOperation.build<DeleteSmsChannelRequest, DeleteSmsChannelResponse> {
            serializer = DeleteSmsChannelOperationSerializer()
            deserializer = DeleteSmsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSmsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSmsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSmsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a message template for messages that were sent through the SMS channel.
     */
    override suspend fun deleteSmsTemplate(input: DeleteSmsTemplateRequest): DeleteSmsTemplateResponse {
        val op = SdkHttpOperation.build<DeleteSmsTemplateRequest, DeleteSmsTemplateResponse> {
            serializer = DeleteSmsTemplateOperationSerializer()
            deserializer = DeleteSmsTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteSmsTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSmsTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSmsTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes all the endpoints that are associated with a specific user ID.
     */
    override suspend fun deleteUserEndpoints(input: DeleteUserEndpointsRequest): DeleteUserEndpointsResponse {
        val op = SdkHttpOperation.build<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse> {
            serializer = DeleteUserEndpointsOperationSerializer()
            deserializer = DeleteUserEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteUserEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteUserEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteUserEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     */
    override suspend fun deleteVoiceChannel(input: DeleteVoiceChannelRequest): DeleteVoiceChannelResponse {
        val op = SdkHttpOperation.build<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse> {
            serializer = DeleteVoiceChannelOperationSerializer()
            deserializer = DeleteVoiceChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVoiceChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVoiceChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVoiceChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a message template for messages that were sent through the voice channel.
     */
    override suspend fun deleteVoiceTemplate(input: DeleteVoiceTemplateRequest): DeleteVoiceTemplateResponse {
        val op = SdkHttpOperation.build<DeleteVoiceTemplateRequest, DeleteVoiceTemplateResponse> {
            serializer = DeleteVoiceTemplateOperationSerializer()
            deserializer = DeleteVoiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteVoiceTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVoiceTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVoiceTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the ADM channel for an application.
     */
    override suspend fun getAdmChannel(input: GetAdmChannelRequest): GetAdmChannelResponse {
        val op = SdkHttpOperation.build<GetAdmChannelRequest, GetAdmChannelResponse> {
            serializer = GetAdmChannelOperationSerializer()
            deserializer = GetAdmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAdmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetAdmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetAdmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the APNs channel for an application.
     */
    override suspend fun getApnsChannel(input: GetApnsChannelRequest): GetApnsChannelResponse {
        val op = SdkHttpOperation.build<GetApnsChannelRequest, GetApnsChannelResponse> {
            serializer = GetApnsChannelOperationSerializer()
            deserializer = GetApnsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApnsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApnsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApnsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     */
    override suspend fun getApnsSandboxChannel(input: GetApnsSandboxChannelRequest): GetApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse> {
            serializer = GetApnsSandboxChannelOperationSerializer()
            deserializer = GetApnsSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApnsSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApnsSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApnsSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     */
    override suspend fun getApnsVoipChannel(input: GetApnsVoipChannelRequest): GetApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse> {
            serializer = GetApnsVoipChannelOperationSerializer()
            deserializer = GetApnsVoipChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApnsVoipChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApnsVoipChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApnsVoipChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     */
    override suspend fun getApnsVoipSandboxChannel(input: GetApnsVoipSandboxChannelRequest): GetApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse> {
            serializer = GetApnsVoipSandboxChannelOperationSerializer()
            deserializer = GetApnsVoipSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApnsVoipSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApnsVoipSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApnsVoipSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about an application.
     */
    override suspend fun getApp(input: GetAppRequest): GetAppResponse {
        val op = SdkHttpOperation.build<GetAppRequest, GetAppResponse> {
            serializer = GetAppOperationSerializer()
            deserializer = GetAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApp"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetAppRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApp-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     */
    override suspend fun getApplicationDateRangeKpi(input: GetApplicationDateRangeKpiRequest): GetApplicationDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse> {
            serializer = GetApplicationDateRangeKpiOperationSerializer()
            deserializer = GetApplicationDateRangeKpiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApplicationDateRangeKpi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApplicationDateRangeKpiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApplicationDateRangeKpi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the settings for an application.
     */
    override suspend fun getApplicationSettings(input: GetApplicationSettingsRequest): GetApplicationSettingsResponse {
        val op = SdkHttpOperation.build<GetApplicationSettingsRequest, GetApplicationSettingsResponse> {
            serializer = GetApplicationSettingsOperationSerializer()
            deserializer = GetApplicationSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApplicationSettings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetApplicationSettingsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApplicationSettings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     */
    override suspend fun getApps(input: GetAppsRequest): GetAppsResponse {
        val op = SdkHttpOperation.build<GetAppsRequest, GetAppsResponse> {
            serializer = GetAppsOperationSerializer()
            deserializer = GetAppsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApps"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetAppsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetApps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the Baidu channel for an application.
     */
    override suspend fun getBaiduChannel(input: GetBaiduChannelRequest): GetBaiduChannelResponse {
        val op = SdkHttpOperation.build<GetBaiduChannelRequest, GetBaiduChannelResponse> {
            serializer = GetBaiduChannelOperationSerializer()
            deserializer = GetBaiduChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBaiduChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBaiduChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBaiduChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a campaign.
     */
    override suspend fun getCampaign(input: GetCampaignRequest): GetCampaignResponse {
        val op = SdkHttpOperation.build<GetCampaignRequest, GetCampaignResponse> {
            serializer = GetCampaignOperationSerializer()
            deserializer = GetCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaign"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaign-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the activities for a campaign.
     */
    override suspend fun getCampaignActivities(input: GetCampaignActivitiesRequest): GetCampaignActivitiesResponse {
        val op = SdkHttpOperation.build<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse> {
            serializer = GetCampaignActivitiesOperationSerializer()
            deserializer = GetCampaignActivitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignActivities"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignActivitiesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaignActivities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     */
    override suspend fun getCampaignDateRangeKpi(input: GetCampaignDateRangeKpiRequest): GetCampaignDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse> {
            serializer = GetCampaignDateRangeKpiOperationSerializer()
            deserializer = GetCampaignDateRangeKpiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignDateRangeKpi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignDateRangeKpiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaignDateRangeKpi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     */
    override suspend fun getCampaignVersion(input: GetCampaignVersionRequest): GetCampaignVersionResponse {
        val op = SdkHttpOperation.build<GetCampaignVersionRequest, GetCampaignVersionResponse> {
            serializer = GetCampaignVersionOperationSerializer()
            deserializer = GetCampaignVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaignVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     */
    override suspend fun getCampaignVersions(input: GetCampaignVersionsRequest): GetCampaignVersionsResponse {
        val op = SdkHttpOperation.build<GetCampaignVersionsRequest, GetCampaignVersionsResponse> {
            serializer = GetCampaignVersionsOperationSerializer()
            deserializer = GetCampaignVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignVersions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignVersionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaignVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.
     */
    override suspend fun getCampaigns(input: GetCampaignsRequest): GetCampaignsResponse {
        val op = SdkHttpOperation.build<GetCampaignsRequest, GetCampaignsResponse> {
            serializer = GetCampaignsOperationSerializer()
            deserializer = GetCampaignsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaigns"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCampaignsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCampaigns-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the history and status of each channel for an application.
     */
    override suspend fun getChannels(input: GetChannelsRequest): GetChannelsResponse {
        val op = SdkHttpOperation.build<GetChannelsRequest, GetChannelsResponse> {
            serializer = GetChannelsOperationSerializer()
            deserializer = GetChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChannels"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetChannelsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetChannels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the email channel for an application.
     */
    override suspend fun getEmailChannel(input: GetEmailChannelRequest): GetEmailChannelResponse {
        val op = SdkHttpOperation.build<GetEmailChannelRequest, GetEmailChannelResponse> {
            serializer = GetEmailChannelOperationSerializer()
            deserializer = GetEmailChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEmailChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEmailChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEmailChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     */
    override suspend fun getEmailTemplate(input: GetEmailTemplateRequest): GetEmailTemplateResponse {
        val op = SdkHttpOperation.build<GetEmailTemplateRequest, GetEmailTemplateResponse> {
            serializer = GetEmailTemplateOperationSerializer()
            deserializer = GetEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEmailTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEmailTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEmailTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     */
    override suspend fun getEndpoint(input: GetEndpointRequest): GetEndpointResponse {
        val op = SdkHttpOperation.build<GetEndpointRequest, GetEndpointResponse> {
            serializer = GetEndpointOperationSerializer()
            deserializer = GetEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEndpoint"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEndpointRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the event stream settings for an application.
     */
    override suspend fun getEventStream(input: GetEventStreamRequest): GetEventStreamResponse {
        val op = SdkHttpOperation.build<GetEventStreamRequest, GetEventStreamResponse> {
            serializer = GetEventStreamOperationSerializer()
            deserializer = GetEventStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventStream"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEventStreamRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEventStream-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of a specific export job for an application.
     */
    override suspend fun getExportJob(input: GetExportJobRequest): GetExportJobResponse {
        val op = SdkHttpOperation.build<GetExportJobRequest, GetExportJobResponse> {
            serializer = GetExportJobOperationSerializer()
            deserializer = GetExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetExportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetExportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of all the export jobs for an application.
     */
    override suspend fun getExportJobs(input: GetExportJobsRequest): GetExportJobsResponse {
        val op = SdkHttpOperation.build<GetExportJobsRequest, GetExportJobsResponse> {
            serializer = GetExportJobsOperationSerializer()
            deserializer = GetExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExportJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetExportJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetExportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the GCM channel for an application.
     */
    override suspend fun getGcmChannel(input: GetGcmChannelRequest): GetGcmChannelResponse {
        val op = SdkHttpOperation.build<GetGcmChannelRequest, GetGcmChannelResponse> {
            serializer = GetGcmChannelOperationSerializer()
            deserializer = GetGcmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGcmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetGcmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetGcmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of a specific import job for an application.
     */
    override suspend fun getImportJob(input: GetImportJobRequest): GetImportJobResponse {
        val op = SdkHttpOperation.build<GetImportJobRequest, GetImportJobResponse> {
            serializer = GetImportJobOperationSerializer()
            deserializer = GetImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetImportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetImportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of all the import jobs for an application.
     */
    override suspend fun getImportJobs(input: GetImportJobsRequest): GetImportJobsResponse {
        val op = SdkHttpOperation.build<GetImportJobsRequest, GetImportJobsResponse> {
            serializer = GetImportJobsOperationSerializer()
            deserializer = GetImportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImportJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetImportJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetImportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the in-app messages targeted for the provided endpoint ID.
     */
    override suspend fun getInAppMessages(input: GetInAppMessagesRequest): GetInAppMessagesResponse {
        val op = SdkHttpOperation.build<GetInAppMessagesRequest, GetInAppMessagesResponse> {
            serializer = GetInAppMessagesOperationSerializer()
            deserializer = GetInAppMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInAppMessages"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetInAppMessagesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetInAppMessages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the content and settings of a message template for messages sent through the in-app channel.
     */
    override suspend fun getInAppTemplate(input: GetInAppTemplateRequest): GetInAppTemplateResponse {
        val op = SdkHttpOperation.build<GetInAppTemplateRequest, GetInAppTemplateResponse> {
            serializer = GetInAppTemplateOperationSerializer()
            deserializer = GetInAppTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInAppTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetInAppTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetInAppTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for a journey.
     */
    override suspend fun getJourney(input: GetJourneyRequest): GetJourneyResponse {
        val op = SdkHttpOperation.build<GetJourneyRequest, GetJourneyResponse> {
            serializer = GetJourneyOperationSerializer()
            deserializer = GetJourneyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJourney"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetJourneyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetJourney-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     */
    override suspend fun getJourneyDateRangeKpi(input: GetJourneyDateRangeKpiRequest): GetJourneyDateRangeKpiResponse {
        val op = SdkHttpOperation.build<GetJourneyDateRangeKpiRequest, GetJourneyDateRangeKpiResponse> {
            serializer = GetJourneyDateRangeKpiOperationSerializer()
            deserializer = GetJourneyDateRangeKpiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJourneyDateRangeKpi"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetJourneyDateRangeKpiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetJourneyDateRangeKpi-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     */
    override suspend fun getJourneyExecutionActivityMetrics(input: GetJourneyExecutionActivityMetricsRequest): GetJourneyExecutionActivityMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyExecutionActivityMetricsRequest, GetJourneyExecutionActivityMetricsResponse> {
            serializer = GetJourneyExecutionActivityMetricsOperationSerializer()
            deserializer = GetJourneyExecutionActivityMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJourneyExecutionActivityMetrics"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetJourneyExecutionActivityMetricsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetJourneyExecutionActivityMetrics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     */
    override suspend fun getJourneyExecutionMetrics(input: GetJourneyExecutionMetricsRequest): GetJourneyExecutionMetricsResponse {
        val op = SdkHttpOperation.build<GetJourneyExecutionMetricsRequest, GetJourneyExecutionMetricsResponse> {
            serializer = GetJourneyExecutionMetricsOperationSerializer()
            deserializer = GetJourneyExecutionMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJourneyExecutionMetrics"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetJourneyExecutionMetricsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetJourneyExecutionMetrics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through a push notification channel.
     */
    override suspend fun getPushTemplate(input: GetPushTemplateRequest): GetPushTemplateResponse {
        val op = SdkHttpOperation.build<GetPushTemplateRequest, GetPushTemplateResponse> {
            serializer = GetPushTemplateOperationSerializer()
            deserializer = GetPushTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPushTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetPushTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetPushTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun getRecommenderConfiguration(input: GetRecommenderConfigurationRequest): GetRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<GetRecommenderConfigurationRequest, GetRecommenderConfigurationResponse> {
            serializer = GetRecommenderConfigurationOperationSerializer()
            deserializer = GetRecommenderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecommenderConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetRecommenderConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRecommenderConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.
     */
    override suspend fun getRecommenderConfigurations(input: GetRecommenderConfigurationsRequest): GetRecommenderConfigurationsResponse {
        val op = SdkHttpOperation.build<GetRecommenderConfigurationsRequest, GetRecommenderConfigurationsResponse> {
            serializer = GetRecommenderConfigurationsOperationSerializer()
            deserializer = GetRecommenderConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecommenderConfigurations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetRecommenderConfigurationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRecommenderConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.
     */
    override suspend fun getSegment(input: GetSegmentRequest): GetSegmentResponse {
        val op = SdkHttpOperation.build<GetSegmentRequest, GetSegmentResponse> {
            serializer = GetSegmentOperationSerializer()
            deserializer = GetSegmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the export jobs for a segment.
     */
    override suspend fun getSegmentExportJobs(input: GetSegmentExportJobsRequest): GetSegmentExportJobsResponse {
        val op = SdkHttpOperation.build<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse> {
            serializer = GetSegmentExportJobsOperationSerializer()
            deserializer = GetSegmentExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegmentExportJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentExportJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegmentExportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the import jobs for a segment.
     */
    override suspend fun getSegmentImportJobs(input: GetSegmentImportJobsRequest): GetSegmentImportJobsResponse {
        val op = SdkHttpOperation.build<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse> {
            serializer = GetSegmentImportJobsOperationSerializer()
            deserializer = GetSegmentImportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegmentImportJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentImportJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegmentImportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.
     */
    override suspend fun getSegmentVersion(input: GetSegmentVersionRequest): GetSegmentVersionResponse {
        val op = SdkHttpOperation.build<GetSegmentVersionRequest, GetSegmentVersionResponse> {
            serializer = GetSegmentVersionOperationSerializer()
            deserializer = GetSegmentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegmentVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegmentVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.
     */
    override suspend fun getSegmentVersions(input: GetSegmentVersionsRequest): GetSegmentVersionsResponse {
        val op = SdkHttpOperation.build<GetSegmentVersionsRequest, GetSegmentVersionsResponse> {
            serializer = GetSegmentVersionsOperationSerializer()
            deserializer = GetSegmentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegmentVersions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentVersionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegmentVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.
     */
    override suspend fun getSegments(input: GetSegmentsRequest): GetSegmentsResponse {
        val op = SdkHttpOperation.build<GetSegmentsRequest, GetSegmentsResponse> {
            serializer = GetSegmentsOperationSerializer()
            deserializer = GetSegmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSegments"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSegmentsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSegments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the SMS channel for an application.
     */
    override suspend fun getSmsChannel(input: GetSmsChannelRequest): GetSmsChannelResponse {
        val op = SdkHttpOperation.build<GetSmsChannelRequest, GetSmsChannelResponse> {
            serializer = GetSmsChannelOperationSerializer()
            deserializer = GetSmsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSmsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSmsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSmsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     */
    override suspend fun getSmsTemplate(input: GetSmsTemplateRequest): GetSmsTemplateResponse {
        val op = SdkHttpOperation.build<GetSmsTemplateRequest, GetSmsTemplateResponse> {
            serializer = GetSmsTemplateOperationSerializer()
            deserializer = GetSmsTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSmsTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSmsTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSmsTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     */
    override suspend fun getUserEndpoints(input: GetUserEndpointsRequest): GetUserEndpointsResponse {
        val op = SdkHttpOperation.build<GetUserEndpointsRequest, GetUserEndpointsResponse> {
            serializer = GetUserEndpointsOperationSerializer()
            deserializer = GetUserEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetUserEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetUserEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status and settings of the voice channel for an application.
     */
    override suspend fun getVoiceChannel(input: GetVoiceChannelRequest): GetVoiceChannelResponse {
        val op = SdkHttpOperation.build<GetVoiceChannelRequest, GetVoiceChannelResponse> {
            serializer = GetVoiceChannelOperationSerializer()
            deserializer = GetVoiceChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVoiceChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVoiceChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     */
    override suspend fun getVoiceTemplate(input: GetVoiceTemplateRequest): GetVoiceTemplateResponse {
        val op = SdkHttpOperation.build<GetVoiceTemplateRequest, GetVoiceTemplateResponse> {
            serializer = GetVoiceTemplateOperationSerializer()
            deserializer = GetVoiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVoiceTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVoiceTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.
     */
    override suspend fun listJourneys(input: ListJourneysRequest): ListJourneysResponse {
        val op = SdkHttpOperation.build<ListJourneysRequest, ListJourneysResponse> {
            serializer = ListJourneysOperationSerializer()
            deserializer = ListJourneysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJourneys"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListJourneysRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListJourneys-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the versions of a specific message template.
     */
    override suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListTemplateVersionsRequest, ListTemplateVersionsResponse> {
            serializer = ListTemplateVersionsOperationSerializer()
            deserializer = ListTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplateVersions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTemplateVersionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTemplateVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplates"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTemplatesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about a phone number.
     */
    override suspend fun phoneNumberValidate(input: PhoneNumberValidateRequest): PhoneNumberValidateResponse {
        val op = SdkHttpOperation.build<PhoneNumberValidateRequest, PhoneNumberValidateResponse> {
            serializer = PhoneNumberValidateOperationSerializer()
            deserializer = PhoneNumberValidateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PhoneNumberValidate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PhoneNumberValidateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PhoneNumberValidate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new event stream for an application or updates the settings of an existing event stream for an application.
     */
    override suspend fun putEventStream(input: PutEventStreamRequest): PutEventStreamResponse {
        val op = SdkHttpOperation.build<PutEventStreamRequest, PutEventStreamResponse> {
            serializer = PutEventStreamOperationSerializer()
            deserializer = PutEventStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEventStream"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutEventStreamRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutEventStream-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.
     */
    override suspend fun putEvents(input: PutEventsRequest): PutEventsResponse {
        val op = SdkHttpOperation.build<PutEventsRequest, PutEventsResponse> {
            serializer = PutEventsOperationSerializer()
            deserializer = PutEventsOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "PutEvents"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutEventsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application.
     */
    override suspend fun removeAttributes(input: RemoveAttributesRequest): RemoveAttributesResponse {
        val op = SdkHttpOperation.build<RemoveAttributesRequest, RemoveAttributesResponse> {
            serializer = RemoveAttributesOperationSerializer()
            deserializer = RemoveAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and sends a direct message.
     */
    override suspend fun sendMessages(input: SendMessagesRequest): SendMessagesResponse {
        val op = SdkHttpOperation.build<SendMessagesRequest, SendMessagesResponse> {
            serializer = SendMessagesOperationSerializer()
            deserializer = SendMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendMessages"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<SendMessagesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SendMessages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Send an OTP message
     */
    override suspend fun sendOtpMessage(input: SendOtpMessageRequest): SendOtpMessageResponse {
        val op = SdkHttpOperation.build<SendOtpMessageRequest, SendOtpMessageResponse> {
            serializer = SendOTPMessageOperationSerializer()
            deserializer = SendOTPMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendOTPMessage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<SendOtpMessageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SendOTPMessage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and sends a message to a list of users.
     */
    override suspend fun sendUsersMessages(input: SendUsersMessagesRequest): SendUsersMessagesResponse {
        val op = SdkHttpOperation.build<SendUsersMessagesRequest, SendUsersMessagesResponse> {
            serializer = SendUsersMessagesOperationSerializer()
            deserializer = SendUsersMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendUsersMessages"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<SendUsersMessagesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SendUsersMessages-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.
     */
    override suspend fun updateAdmChannel(input: UpdateAdmChannelRequest): UpdateAdmChannelResponse {
        val op = SdkHttpOperation.build<UpdateAdmChannelRequest, UpdateAdmChannelResponse> {
            serializer = UpdateAdmChannelOperationSerializer()
            deserializer = UpdateAdmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAdmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateAdmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAdmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.
     */
    override suspend fun updateApnsChannel(input: UpdateApnsChannelRequest): UpdateApnsChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsChannelRequest, UpdateApnsChannelResponse> {
            serializer = UpdateApnsChannelOperationSerializer()
            deserializer = UpdateApnsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApnsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApnsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApnsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.
     */
    override suspend fun updateApnsSandboxChannel(input: UpdateApnsSandboxChannelRequest): UpdateApnsSandboxChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse> {
            serializer = UpdateApnsSandboxChannelOperationSerializer()
            deserializer = UpdateApnsSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApnsSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApnsSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApnsSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.
     */
    override suspend fun updateApnsVoipChannel(input: UpdateApnsVoipChannelRequest): UpdateApnsVoipChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse> {
            serializer = UpdateApnsVoipChannelOperationSerializer()
            deserializer = UpdateApnsVoipChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApnsVoipChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApnsVoipChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApnsVoipChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.
     */
    override suspend fun updateApnsVoipSandboxChannel(input: UpdateApnsVoipSandboxChannelRequest): UpdateApnsVoipSandboxChannelResponse {
        val op = SdkHttpOperation.build<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse> {
            serializer = UpdateApnsVoipSandboxChannelOperationSerializer()
            deserializer = UpdateApnsVoipSandboxChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApnsVoipSandboxChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApnsVoipSandboxChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApnsVoipSandboxChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the settings for an application.
     */
    override suspend fun updateApplicationSettings(input: UpdateApplicationSettingsRequest): UpdateApplicationSettingsResponse {
        val op = SdkHttpOperation.build<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse> {
            serializer = UpdateApplicationSettingsOperationSerializer()
            deserializer = UpdateApplicationSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplicationSettings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateApplicationSettingsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateApplicationSettings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.
     */
    override suspend fun updateBaiduChannel(input: UpdateBaiduChannelRequest): UpdateBaiduChannelResponse {
        val op = SdkHttpOperation.build<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse> {
            serializer = UpdateBaiduChannelOperationSerializer()
            deserializer = UpdateBaiduChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBaiduChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBaiduChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBaiduChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration and other settings for a campaign.
     */
    override suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse {
        val op = SdkHttpOperation.build<UpdateCampaignRequest, UpdateCampaignResponse> {
            serializer = UpdateCampaignOperationSerializer()
            deserializer = UpdateCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCampaign"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCampaignRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCampaign-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the email channel for an application or updates the status and settings of the email channel for an application.
     */
    override suspend fun updateEmailChannel(input: UpdateEmailChannelRequest): UpdateEmailChannelResponse {
        val op = SdkHttpOperation.build<UpdateEmailChannelRequest, UpdateEmailChannelResponse> {
            serializer = UpdateEmailChannelOperationSerializer()
            deserializer = UpdateEmailChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEmailChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEmailChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEmailChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing message template for messages that are sent through the email channel.
     */
    override suspend fun updateEmailTemplate(input: UpdateEmailTemplateRequest): UpdateEmailTemplateResponse {
        val op = SdkHttpOperation.build<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse> {
            serializer = UpdateEmailTemplateOperationSerializer()
            deserializer = UpdateEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateEmailTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEmailTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEmailTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    override suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse {
        val op = SdkHttpOperation.build<UpdateEndpointRequest, UpdateEndpointResponse> {
            serializer = UpdateEndpointOperationSerializer()
            deserializer = UpdateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateEndpoint"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEndpointRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.
     */
    override suspend fun updateEndpointsBatch(input: UpdateEndpointsBatchRequest): UpdateEndpointsBatchResponse {
        val op = SdkHttpOperation.build<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse> {
            serializer = UpdateEndpointsBatchOperationSerializer()
            deserializer = UpdateEndpointsBatchOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateEndpointsBatch"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEndpointsBatchRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEndpointsBatch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.
     */
    override suspend fun updateGcmChannel(input: UpdateGcmChannelRequest): UpdateGcmChannelResponse {
        val op = SdkHttpOperation.build<UpdateGcmChannelRequest, UpdateGcmChannelResponse> {
            serializer = UpdateGcmChannelOperationSerializer()
            deserializer = UpdateGcmChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGcmChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateGcmChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateGcmChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing message template for messages sent through the in-app message channel.
     */
    override suspend fun updateInAppTemplate(input: UpdateInAppTemplateRequest): UpdateInAppTemplateResponse {
        val op = SdkHttpOperation.build<UpdateInAppTemplateRequest, UpdateInAppTemplateResponse> {
            serializer = UpdateInAppTemplateOperationSerializer()
            deserializer = UpdateInAppTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateInAppTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateInAppTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateInAppTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration and other settings for a journey.
     */
    override suspend fun updateJourney(input: UpdateJourneyRequest): UpdateJourneyResponse {
        val op = SdkHttpOperation.build<UpdateJourneyRequest, UpdateJourneyResponse> {
            serializer = UpdateJourneyOperationSerializer()
            deserializer = UpdateJourneyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateJourney"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateJourneyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateJourney-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels (stops) an active journey.
     */
    override suspend fun updateJourneyState(input: UpdateJourneyStateRequest): UpdateJourneyStateResponse {
        val op = SdkHttpOperation.build<UpdateJourneyStateRequest, UpdateJourneyStateResponse> {
            serializer = UpdateJourneyStateOperationSerializer()
            deserializer = UpdateJourneyStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateJourneyState"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateJourneyStateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateJourneyState-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing message template for messages that are sent through a push notification channel.
     */
    override suspend fun updatePushTemplate(input: UpdatePushTemplateRequest): UpdatePushTemplateResponse {
        val op = SdkHttpOperation.build<UpdatePushTemplateRequest, UpdatePushTemplateResponse> {
            serializer = UpdatePushTemplateOperationSerializer()
            deserializer = UpdatePushTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdatePushTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdatePushTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdatePushTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an Amazon Pinpoint configuration for a recommender model.
     */
    override suspend fun updateRecommenderConfiguration(input: UpdateRecommenderConfigurationRequest): UpdateRecommenderConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateRecommenderConfigurationRequest, UpdateRecommenderConfigurationResponse> {
            serializer = UpdateRecommenderConfigurationOperationSerializer()
            deserializer = UpdateRecommenderConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRecommenderConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateRecommenderConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRecommenderConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.
     */
    override suspend fun updateSegment(input: UpdateSegmentRequest): UpdateSegmentResponse {
        val op = SdkHttpOperation.build<UpdateSegmentRequest, UpdateSegmentResponse> {
            serializer = UpdateSegmentOperationSerializer()
            deserializer = UpdateSegmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSegment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSegmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSegment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.
     */
    override suspend fun updateSmsChannel(input: UpdateSmsChannelRequest): UpdateSmsChannelResponse {
        val op = SdkHttpOperation.build<UpdateSmsChannelRequest, UpdateSmsChannelResponse> {
            serializer = UpdateSmsChannelOperationSerializer()
            deserializer = UpdateSmsChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSmsChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSmsChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSmsChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing message template for messages that are sent through the SMS channel.
     */
    override suspend fun updateSmsTemplate(input: UpdateSmsTemplateRequest): UpdateSmsTemplateResponse {
        val op = SdkHttpOperation.build<UpdateSmsTemplateRequest, UpdateSmsTemplateResponse> {
            serializer = UpdateSmsTemplateOperationSerializer()
            deserializer = UpdateSmsTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateSmsTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSmsTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSmsTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes the status of a specific version of a message template to *active*.
     */
    override suspend fun updateTemplateActiveVersion(input: UpdateTemplateActiveVersionRequest): UpdateTemplateActiveVersionResponse {
        val op = SdkHttpOperation.build<UpdateTemplateActiveVersionRequest, UpdateTemplateActiveVersionResponse> {
            serializer = UpdateTemplateActiveVersionOperationSerializer()
            deserializer = UpdateTemplateActiveVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTemplateActiveVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateTemplateActiveVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateTemplateActiveVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an application.
     */
    override suspend fun updateVoiceChannel(input: UpdateVoiceChannelRequest): UpdateVoiceChannelResponse {
        val op = SdkHttpOperation.build<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse> {
            serializer = UpdateVoiceChannelOperationSerializer()
            deserializer = UpdateVoiceChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVoiceChannel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVoiceChannelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVoiceChannel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing message template for messages that are sent through the voice channel.
     */
    override suspend fun updateVoiceTemplate(input: UpdateVoiceTemplateRequest): UpdateVoiceTemplateResponse {
        val op = SdkHttpOperation.build<UpdateVoiceTemplateRequest, UpdateVoiceTemplateResponse> {
            serializer = UpdateVoiceTemplateOperationSerializer()
            deserializer = UpdateVoiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateVoiceTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVoiceTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVoiceTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Verify an OTP
     */
    override suspend fun verifyOtpMessage(input: VerifyOtpMessageRequest): VerifyOtpMessageResponse {
        val op = SdkHttpOperation.build<VerifyOtpMessageRequest, VerifyOtpMessageResponse> {
            serializer = VerifyOTPMessageOperationSerializer()
            deserializer = VerifyOTPMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "VerifyOTPMessage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<VerifyOtpMessageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "mobiletargeting"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("VerifyOTPMessage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mobiletargeting")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
