// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.pi.auth.DefaultPiAuthSchemeProvider
import aws.sdk.kotlin.services.pi.auth.PiAuthSchemeProvider
import aws.sdk.kotlin.services.pi.endpoints.DefaultPiEndpointProvider
import aws.sdk.kotlin.services.pi.endpoints.PiEndpointParameters
import aws.sdk.kotlin.services.pi.endpoints.PiEndpointProvider
import aws.sdk.kotlin.services.pi.model.CreatePerformanceAnalysisReportRequest
import aws.sdk.kotlin.services.pi.model.CreatePerformanceAnalysisReportResponse
import aws.sdk.kotlin.services.pi.model.DeletePerformanceAnalysisReportRequest
import aws.sdk.kotlin.services.pi.model.DeletePerformanceAnalysisReportResponse
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysResponse
import aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsRequest
import aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsResponse
import aws.sdk.kotlin.services.pi.model.GetPerformanceAnalysisReportRequest
import aws.sdk.kotlin.services.pi.model.GetPerformanceAnalysisReportResponse
import aws.sdk.kotlin.services.pi.model.GetResourceMetadataRequest
import aws.sdk.kotlin.services.pi.model.GetResourceMetadataResponse
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.ListPerformanceAnalysisReportsRequest
import aws.sdk.kotlin.services.pi.model.ListPerformanceAnalysisReportsResponse
import aws.sdk.kotlin.services.pi.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pi.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.pi.model.TagResourceRequest
import aws.sdk.kotlin.services.pi.model.TagResourceResponse
import aws.sdk.kotlin.services.pi.model.UntagResourceRequest
import aws.sdk.kotlin.services.pi.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "PI"
public const val SdkVersion: String = "1.5.51"
public const val ServiceApiVersion: String = "2018-02-27"

/**
 * # Amazon RDS Performance Insights
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. The guide provides detailed information about Performance Insights data types, parameters and errors.
 *
 * When Performance Insights is enabled, the Amazon RDS Performance Insights API provides visibility into the performance of your DB instance. Amazon CloudWatch provides the authoritative source for Amazon Web Services service-vended monitoring metrics. Performance Insights offers a domain-specific view of DB load.
 *
 * DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * + To learn more about Performance Insights and Amazon Aurora DB instances, go to the *[ Amazon Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html)*.
 * + To learn more about Performance Insights and Amazon RDS DB instances, go to the *[ Amazon RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)*.
 * + To learn more about Performance Insights and Amazon DocumentDB clusters, go to the *[ Amazon DocumentDB Developer Guide](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html)*.
 */
public interface PiClient : SdkClient {
    /**
     * PiClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, PiClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Pi",
                "PI",
                "pi",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, PiClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): PiClient = DefaultPiClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: PiEndpointProvider = builder.endpointProvider ?: DefaultPiEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: PiAuthSchemeProvider = builder.authSchemeProvider ?: DefaultPiAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "PI"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: PiEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: PiAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new performance analysis report for a specific time period for the DB instance.
     */
    public suspend fun createPerformanceAnalysisReport(input: CreatePerformanceAnalysisReportRequest): CreatePerformanceAnalysisReportResponse

    /**
     * Deletes a performance analysis report.
     */
    public suspend fun deletePerformanceAnalysisReport(input: DeletePerformanceAnalysisReportRequest): DeletePerformanceAnalysisReportResponse

    /**
     * For a specific time period, retrieve the top `N` dimension keys for a metric.
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
     */
    public suspend fun describeDimensionKeys(input: DescribeDimensionKeysRequest): DescribeDimensionKeysResponse

    /**
     * Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a SQL ID, `GetDimensionKeyDetails` retrieves the full text of the dimension `db.sql.statement` associated with this ID. This operation is useful because `GetResourceMetrics` and `DescribeDimensionKeys` don't support retrieval of large SQL statement text, lock snapshots, and execution plans.
     */
    public suspend fun getDimensionKeyDetails(input: GetDimensionKeyDetailsRequest): GetDimensionKeyDetailsResponse

    /**
     * Retrieves the report including the report ID, status, time details, and the insights with recommendations. The report status can be `RUNNING`, `SUCCEEDED`, or `FAILED`. The insights include the `description` and `recommendation` fields.
     */
    public suspend fun getPerformanceAnalysisReport(input: GetPerformanceAnalysisReportRequest): GetPerformanceAnalysisReportResponse

    /**
     * Retrieve the metadata for different features. For example, the metadata might indicate that a feature is turned on or off on a specific DB instance.
     */
    public suspend fun getResourceMetadata(input: GetResourceMetadataRequest): GetResourceMetadataResponse

    /**
     * Retrieve Performance Insights metrics for a set of data sources over a time period. You can provide specific dimension groups and dimensions, and provide filtering criteria for each group. You must specify an aggregate function for each metric.
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
     */
    public suspend fun getResourceMetrics(input: GetResourceMetricsRequest): GetResourceMetricsResponse

    /**
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     */
    public suspend fun listAvailableResourceDimensions(input: ListAvailableResourceDimensionsRequest): ListAvailableResourceDimensionsResponse

    /**
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     */
    public suspend fun listAvailableResourceMetrics(input: ListAvailableResourceMetricsRequest): ListAvailableResourceMetricsResponse

    /**
     * Lists all the analysis reports created for the DB instance. The reports are sorted based on the start time of each report.
     */
    public suspend fun listPerformanceAnalysisReports(input: ListPerformanceAnalysisReportsRequest): ListPerformanceAnalysisReportsResponse

    /**
     * Retrieves all the metadata tags associated with Amazon RDS Performance Insights resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds metadata tags to the Amazon RDS Performance Insights resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes the metadata tags from the Amazon RDS Performance Insights resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun PiClient.withConfig(block: PiClient.Config.Builder.() -> Unit): PiClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultPiClient(newConfig)
}

/**
 * Creates a new performance analysis report for a specific time period for the DB instance.
 */
public suspend inline fun PiClient.createPerformanceAnalysisReport(crossinline block: CreatePerformanceAnalysisReportRequest.Builder.() -> Unit): CreatePerformanceAnalysisReportResponse = createPerformanceAnalysisReport(CreatePerformanceAnalysisReportRequest.Builder().apply(block).build())

/**
 * Deletes a performance analysis report.
 */
public suspend inline fun PiClient.deletePerformanceAnalysisReport(crossinline block: DeletePerformanceAnalysisReportRequest.Builder.() -> Unit): DeletePerformanceAnalysisReportResponse = deletePerformanceAnalysisReport(DeletePerformanceAnalysisReportRequest.Builder().apply(block).build())

/**
 * For a specific time period, retrieve the top `N` dimension keys for a metric.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
 */
public suspend inline fun PiClient.describeDimensionKeys(crossinline block: DescribeDimensionKeysRequest.Builder.() -> Unit): DescribeDimensionKeysResponse = describeDimensionKeys(DescribeDimensionKeysRequest.Builder().apply(block).build())

/**
 * Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a SQL ID, `GetDimensionKeyDetails` retrieves the full text of the dimension `db.sql.statement` associated with this ID. This operation is useful because `GetResourceMetrics` and `DescribeDimensionKeys` don't support retrieval of large SQL statement text, lock snapshots, and execution plans.
 */
public suspend inline fun PiClient.getDimensionKeyDetails(crossinline block: GetDimensionKeyDetailsRequest.Builder.() -> Unit): GetDimensionKeyDetailsResponse = getDimensionKeyDetails(GetDimensionKeyDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves the report including the report ID, status, time details, and the insights with recommendations. The report status can be `RUNNING`, `SUCCEEDED`, or `FAILED`. The insights include the `description` and `recommendation` fields.
 */
public suspend inline fun PiClient.getPerformanceAnalysisReport(crossinline block: GetPerformanceAnalysisReportRequest.Builder.() -> Unit): GetPerformanceAnalysisReportResponse = getPerformanceAnalysisReport(GetPerformanceAnalysisReportRequest.Builder().apply(block).build())

/**
 * Retrieve the metadata for different features. For example, the metadata might indicate that a feature is turned on or off on a specific DB instance.
 */
public suspend inline fun PiClient.getResourceMetadata(crossinline block: GetResourceMetadataRequest.Builder.() -> Unit): GetResourceMetadataResponse = getResourceMetadata(GetResourceMetadataRequest.Builder().apply(block).build())

/**
 * Retrieve Performance Insights metrics for a set of data sources over a time period. You can provide specific dimension groups and dimensions, and provide filtering criteria for each group. You must specify an aggregate function for each metric.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
 */
public suspend inline fun PiClient.getResourceMetrics(crossinline block: GetResourceMetricsRequest.Builder.() -> Unit): GetResourceMetricsResponse = getResourceMetrics(GetResourceMetricsRequest.Builder().apply(block).build())

/**
 * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
 */
public suspend inline fun PiClient.listAvailableResourceDimensions(crossinline block: ListAvailableResourceDimensionsRequest.Builder.() -> Unit): ListAvailableResourceDimensionsResponse = listAvailableResourceDimensions(ListAvailableResourceDimensionsRequest.Builder().apply(block).build())

/**
 * Retrieve metrics of the specified types that can be queried for a specified DB instance.
 */
public suspend inline fun PiClient.listAvailableResourceMetrics(crossinline block: ListAvailableResourceMetricsRequest.Builder.() -> Unit): ListAvailableResourceMetricsResponse = listAvailableResourceMetrics(ListAvailableResourceMetricsRequest.Builder().apply(block).build())

/**
 * Lists all the analysis reports created for the DB instance. The reports are sorted based on the start time of each report.
 */
public suspend inline fun PiClient.listPerformanceAnalysisReports(crossinline block: ListPerformanceAnalysisReportsRequest.Builder.() -> Unit): ListPerformanceAnalysisReportsResponse = listPerformanceAnalysisReports(ListPerformanceAnalysisReportsRequest.Builder().apply(block).build())

/**
 * Retrieves all the metadata tags associated with Amazon RDS Performance Insights resource.
 */
public suspend inline fun PiClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to the Amazon RDS Performance Insights resource.
 */
public suspend inline fun PiClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes the metadata tags from the Amazon RDS Performance Insights resource.
 */
public suspend inline fun PiClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
