// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.paginators

import aws.sdk.kotlin.services.pi.PiClient
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysResponse
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.ListPerformanceAnalysisReportsRequest
import aws.sdk.kotlin.services.pi.model.ListPerformanceAnalysisReportsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeDimensionKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDimensionKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDimensionKeysResponse]
 */
public fun PiClient.describeDimensionKeysPaginated(initialRequest: DescribeDimensionKeysRequest): Flow<DescribeDimensionKeysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDimensionKeysPaginated.describeDimensionKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDimensionKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDimensionKeysResponse]
 */
public fun PiClient.describeDimensionKeysPaginated(block: DescribeDimensionKeysRequest.Builder.() -> Unit): Flow<DescribeDimensionKeysResponse> =
    describeDimensionKeysPaginated(DescribeDimensionKeysRequest.Builder().apply(block).build())

/**
 * Paginate over [GetResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetResourceMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceMetricsResponse]
 */
public fun PiClient.getResourceMetricsPaginated(initialRequest: GetResourceMetricsRequest): Flow<GetResourceMetricsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getResourceMetricsPaginated.getResourceMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceMetricsResponse]
 */
public fun PiClient.getResourceMetricsPaginated(block: GetResourceMetricsRequest.Builder.() -> Unit): Flow<GetResourceMetricsResponse> =
    getResourceMetricsPaginated(GetResourceMetricsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAvailableResourceDimensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAvailableResourceDimensionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceDimensionsResponse]
 */
public fun PiClient.listAvailableResourceDimensionsPaginated(initialRequest: ListAvailableResourceDimensionsRequest): Flow<ListAvailableResourceDimensionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAvailableResourceDimensionsPaginated.listAvailableResourceDimensions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAvailableResourceDimensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceDimensionsResponse]
 */
public fun PiClient.listAvailableResourceDimensionsPaginated(block: ListAvailableResourceDimensionsRequest.Builder.() -> Unit): Flow<ListAvailableResourceDimensionsResponse> =
    listAvailableResourceDimensionsPaginated(ListAvailableResourceDimensionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAvailableResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAvailableResourceMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceMetricsResponse]
 */
public fun PiClient.listAvailableResourceMetricsPaginated(initialRequest: ListAvailableResourceMetricsRequest): Flow<ListAvailableResourceMetricsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAvailableResourceMetricsPaginated.listAvailableResourceMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAvailableResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceMetricsResponse]
 */
public fun PiClient.listAvailableResourceMetricsPaginated(block: ListAvailableResourceMetricsRequest.Builder.() -> Unit): Flow<ListAvailableResourceMetricsResponse> =
    listAvailableResourceMetricsPaginated(ListAvailableResourceMetricsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPerformanceAnalysisReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPerformanceAnalysisReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPerformanceAnalysisReportsResponse]
 */
public fun PiClient.listPerformanceAnalysisReportsPaginated(initialRequest: ListPerformanceAnalysisReportsRequest): Flow<ListPerformanceAnalysisReportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPerformanceAnalysisReportsPaginated.listPerformanceAnalysisReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPerformanceAnalysisReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPerformanceAnalysisReportsResponse]
 */
public fun PiClient.listPerformanceAnalysisReportsPaginated(block: ListPerformanceAnalysisReportsRequest.Builder.() -> Unit): Flow<ListPerformanceAnalysisReportsResponse> =
    listPerformanceAnalysisReportsPaginated(ListPerformanceAnalysisReportsRequest.Builder().apply(block).build())
