// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the `db.sql` dimension group consists of the following dimensions:
 * + `db.sql.id` - The hash of a running SQL statement, generated by Performance Insights.
 * + `db.sql.db_id` - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with `pi-`.
 * + `db.sql.statement` - The full text of the SQL statement that is running, for example, `SELECT * FROM employees`.
 * + `db.sql_tokenized.id` - The hash of the SQL digest generated by Performance Insights.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
 */
public class DimensionGroup private constructor(builder: Builder) {
    /**
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.
     *
     * Valid values for elements in the `Dimensions` array are:
     * + `db.application.name` - The name of the application that is connected to the database. Valid values are as follows:
     *    + Aurora PostgreSQL
     *    + Amazon RDS PostgreSQL
     *    + Amazon DocumentDB
     * + `db.blocking_sql.id` - The ID for each of the SQL queries blocking the most DB load.
     * + `db.blocking_sql.sql` - The SQL text for each of the SQL queries blocking the most DB load.
     * + `db.blocking_session.id` - The ID for each of the sessions blocking the most DB load.
     * + `db.blocking_object.id` - The ID for each of the object resources acquired by other sessions that are blocking the most DB load.
     * + `db.blocking_object.type` - The object type for each of the object resources acquired by other sessions that are blocking the most DB load.
     * + `db.blocking_object.value` - The value for each of the object resources acquired by other sessions that are blocking the most DB load.
     * + `db.host.id` - The host ID of the connected client (all engines).
     * + `db.host.name` - The host name of the connected client (all engines).
     * + `db.name` - The name of the database to which the client is connected. Valid values are as follows:
     *    + Aurora PostgreSQL
     *    + Amazon RDS PostgreSQL
     *    + Aurora MySQL
     *    + Amazon RDS MySQL
     *    + Amazon RDS MariaDB
     *    + Amazon DocumentDB
     * + `db.query.id` - The query ID generated by Performance Insights (only Amazon DocumentDB).
     * + `db.query.db_id` - The query ID generated by the database (only Amazon DocumentDB).
     * + `db.query.statement` - The text of the query that is being run (only Amazon DocumentDB).
     * + `db.query.tokenized_id`
     * + `db.query.tokenized.id` - The query digest ID generated by Performance Insights (only Amazon DocumentDB).
     * + `db.query.tokenized.db_id` - The query digest ID generated by Performance Insights (only Amazon DocumentDB).
     * + `db.query.tokenized.statement` - The text of the query digest (only Amazon DocumentDB).
     * + `db.session_type.name` - The type of the current session (only Amazon DocumentDB).
     * + `db.sql.id` - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).
     * + `db.sql.db_id` - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with `pi-` (all engines except Amazon DocumentDB).
     * + `db.sql.statement` - The full text of the SQL statement that is running, as in `SELECT * FROM employees` (all engines except Amazon DocumentDB)
     * + `db.sql.tokenized_id` - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). The `db.sql.tokenized_id` dimension fetches the value of the `db.sql_tokenized.id` dimension. Amazon RDS returns `db.sql.tokenized_id` from the `db.sql` dimension group.
     * + `db.sql_tokenized.id` - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, `db.sql_tokenized.id` is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
     * + `db.sql_tokenized.db_id` - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as `pi-2372568224` that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).
     * + `db.sql_tokenized.statement` - The text of the SQL digest, as in `SELECT * FROM employees WHERE employee_id = ?` (all engines except Amazon DocumentDB)
     * + `db.user.id` - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
     * + `db.user.name` - The name of the user logged in to the database (all engines except Amazon DocumentDB).
     * + `db.wait_event.name` - The event for which the backend is waiting (all engines except Amazon DocumentDB).
     * + `db.wait_event.type` - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).
     * + `db.wait_event_type.name` - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).
     * + `db.wait_state.name` - The event for which the backend is waiting (only Amazon DocumentDB).
     */
    public val dimensions: List<String>? = builder.dimensions
    /**
     * The name of the dimension group. Valid values are as follows:
     * + `db` - The name of the database to which the client is connected. The following values are permitted:
     *    + Aurora PostgreSQL
     *    + Amazon RDS PostgreSQL
     *    + Aurora MySQL
     *    + Amazon RDS MySQL
     *    + Amazon RDS MariaDB
     *    + Amazon DocumentDB
     * + `db.application` - The name of the application that is connected to the database. The following values are permitted:
     *    + Aurora PostgreSQL
     *    + Amazon RDS PostgreSQL
     *    + Amazon DocumentDB
     * + `db.blocking_sql` - The SQL queries blocking the most DB load.
     * + `db.blocking_session` - The sessions blocking the most DB load.
     * + `db.blocking_object` - The object resources acquired by other sessions that are blocking the most DB load.
     * + `db.host` - The host name of the connected client (all engines).
     * + `db.plans` - The execution plans for the query (only Aurora PostgreSQL).
     * + `db.query` - The query that is currently running (only Amazon DocumentDB).
     * + `db.query_tokenized` - The digest query (only Amazon DocumentDB).
     * + `db.session_type` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
     * + `db.sql` - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).
     * + `db.sql_tokenized` - The SQL digest (all engines except Amazon DocumentDB).
     * + `db.user` - The user logged in to the database (all engines except Amazon DocumentDB).
     * + `db.wait_event` - The event for which the database backend is waiting (all engines except Amazon DocumentDB).
     * + `db.wait_event_type` - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).
     * + `db.wait_state` - The event for which the database backend is waiting (only Amazon DocumentDB).
     */
    public val group: kotlin.String = requireNotNull(builder.group) { "A non-null value must be provided for group" }
    /**
     * The maximum number of items to fetch for this dimension group.
     */
    public val limit: kotlin.Int? = builder.limit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.DimensionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DimensionGroup(")
        append("dimensions=$dimensions,")
        append("group=$group,")
        append("limit=$limit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (group.hashCode())
        result = 31 * result + (limit ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DimensionGroup

        if (dimensions != other.dimensions) return false
        if (group != other.group) return false
        if (limit != other.limit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.DimensionGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.
         *
         * Valid values for elements in the `Dimensions` array are:
         * + `db.application.name` - The name of the application that is connected to the database. Valid values are as follows:
         *    + Aurora PostgreSQL
         *    + Amazon RDS PostgreSQL
         *    + Amazon DocumentDB
         * + `db.blocking_sql.id` - The ID for each of the SQL queries blocking the most DB load.
         * + `db.blocking_sql.sql` - The SQL text for each of the SQL queries blocking the most DB load.
         * + `db.blocking_session.id` - The ID for each of the sessions blocking the most DB load.
         * + `db.blocking_object.id` - The ID for each of the object resources acquired by other sessions that are blocking the most DB load.
         * + `db.blocking_object.type` - The object type for each of the object resources acquired by other sessions that are blocking the most DB load.
         * + `db.blocking_object.value` - The value for each of the object resources acquired by other sessions that are blocking the most DB load.
         * + `db.host.id` - The host ID of the connected client (all engines).
         * + `db.host.name` - The host name of the connected client (all engines).
         * + `db.name` - The name of the database to which the client is connected. Valid values are as follows:
         *    + Aurora PostgreSQL
         *    + Amazon RDS PostgreSQL
         *    + Aurora MySQL
         *    + Amazon RDS MySQL
         *    + Amazon RDS MariaDB
         *    + Amazon DocumentDB
         * + `db.query.id` - The query ID generated by Performance Insights (only Amazon DocumentDB).
         * + `db.query.db_id` - The query ID generated by the database (only Amazon DocumentDB).
         * + `db.query.statement` - The text of the query that is being run (only Amazon DocumentDB).
         * + `db.query.tokenized_id`
         * + `db.query.tokenized.id` - The query digest ID generated by Performance Insights (only Amazon DocumentDB).
         * + `db.query.tokenized.db_id` - The query digest ID generated by Performance Insights (only Amazon DocumentDB).
         * + `db.query.tokenized.statement` - The text of the query digest (only Amazon DocumentDB).
         * + `db.session_type.name` - The type of the current session (only Amazon DocumentDB).
         * + `db.sql.id` - The hash of the full, non-tokenized SQL statement generated by Performance Insights (all engines except Amazon DocumentDB).
         * + `db.sql.db_id` - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with `pi-` (all engines except Amazon DocumentDB).
         * + `db.sql.statement` - The full text of the SQL statement that is running, as in `SELECT * FROM employees` (all engines except Amazon DocumentDB)
         * + `db.sql.tokenized_id` - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). The `db.sql.tokenized_id` dimension fetches the value of the `db.sql_tokenized.id` dimension. Amazon RDS returns `db.sql.tokenized_id` from the `db.sql` dimension group.
         * + `db.sql_tokenized.id` - The hash of the SQL digest generated by Performance Insights (all engines except Amazon DocumentDB). In the console, `db.sql_tokenized.id` is called the Support ID because Amazon Web Services Support can look at this data to help you troubleshoot database issues.
         * + `db.sql_tokenized.db_id` - Either the native database ID used to refer to the SQL statement, or a synthetic ID such as `pi-2372568224` that Performance Insights generates if the native database ID isn't available (all engines except Amazon DocumentDB).
         * + `db.sql_tokenized.statement` - The text of the SQL digest, as in `SELECT * FROM employees WHERE employee_id = ?` (all engines except Amazon DocumentDB)
         * + `db.user.id` - The ID of the user logged in to the database (all engines except Amazon DocumentDB).
         * + `db.user.name` - The name of the user logged in to the database (all engines except Amazon DocumentDB).
         * + `db.wait_event.name` - The event for which the backend is waiting (all engines except Amazon DocumentDB).
         * + `db.wait_event.type` - The type of event for which the backend is waiting (all engines except Amazon DocumentDB).
         * + `db.wait_event_type.name` - The name of the event type for which the backend is waiting (all engines except Amazon DocumentDB).
         * + `db.wait_state.name` - The event for which the backend is waiting (only Amazon DocumentDB).
         */
        public var dimensions: List<String>? = null
        /**
         * The name of the dimension group. Valid values are as follows:
         * + `db` - The name of the database to which the client is connected. The following values are permitted:
         *    + Aurora PostgreSQL
         *    + Amazon RDS PostgreSQL
         *    + Aurora MySQL
         *    + Amazon RDS MySQL
         *    + Amazon RDS MariaDB
         *    + Amazon DocumentDB
         * + `db.application` - The name of the application that is connected to the database. The following values are permitted:
         *    + Aurora PostgreSQL
         *    + Amazon RDS PostgreSQL
         *    + Amazon DocumentDB
         * + `db.blocking_sql` - The SQL queries blocking the most DB load.
         * + `db.blocking_session` - The sessions blocking the most DB load.
         * + `db.blocking_object` - The object resources acquired by other sessions that are blocking the most DB load.
         * + `db.host` - The host name of the connected client (all engines).
         * + `db.plans` - The execution plans for the query (only Aurora PostgreSQL).
         * + `db.query` - The query that is currently running (only Amazon DocumentDB).
         * + `db.query_tokenized` - The digest query (only Amazon DocumentDB).
         * + `db.session_type` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL).
         * + `db.sql` - The text of the SQL statement that is currently running (all engines except Amazon DocumentDB).
         * + `db.sql_tokenized` - The SQL digest (all engines except Amazon DocumentDB).
         * + `db.user` - The user logged in to the database (all engines except Amazon DocumentDB).
         * + `db.wait_event` - The event for which the database backend is waiting (all engines except Amazon DocumentDB).
         * + `db.wait_event_type` - The type of event for which the database backend is waiting (all engines except Amazon DocumentDB).
         * + `db.wait_state` - The event for which the database backend is waiting (only Amazon DocumentDB).
         */
        public var group: kotlin.String? = null
        /**
         * The maximum number of items to fetch for this dimension group.
         */
        public var limit: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.DimensionGroup) : this() {
            this.dimensions = x.dimensions
            this.group = x.group
            this.limit = x.limit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.DimensionGroup = DimensionGroup(this)

        internal fun correctErrors(): Builder {
            if (group == null) group = ""
            return this
        }
    }
}
