// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.serde

import aws.sdk.kotlin.services.pi.model.GetResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.MetricKeyDataPoints
import aws.sdk.kotlin.services.pi.model.PiException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetResourceMetricsOperationDeserializer: HttpDeserializer.NonStreaming<GetResourceMetricsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetResourceMetricsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourceMetricsError(context, call, payload)
        }
        val builder = GetResourceMetricsResponse.Builder()

        if (payload != null) {
            deserializeGetResourceMetricsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetResourceMetricsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PiException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceMetricsOperationBody(builder: GetResourceMetricsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIGNEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedEndTime"))
    val ALIGNEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedStartTime"))
    val IDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Identifier"))
    val METRICLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MetricList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIGNEDENDTIME_DESCRIPTOR)
        field(ALIGNEDSTARTTIME_DESCRIPTOR)
        field(IDENTIFIER_DESCRIPTOR)
        field(METRICLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIGNEDENDTIME_DESCRIPTOR.index -> builder.alignedEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ALIGNEDSTARTTIME_DESCRIPTOR.index -> builder.alignedStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                IDENTIFIER_DESCRIPTOR.index -> builder.identifier = deserializeString()
                METRICLIST_DESCRIPTOR.index -> builder.metricList =
                    deserializer.deserializeList(METRICLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricKeyDataPoints>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricKeyDataPointsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
