// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAvailableResourceMetricsRequest private constructor(builder: Builder) {
    /**
     * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VWZ`.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * The maximum number of items to return. If the `MaxRecords` value is less than the number of existing items, the response includes a pagination token.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The types of metrics to return in the response. Valid values in the array include the following:
     * + `os` (OS counter metrics) - All engines
     * + `db` (DB load metrics) - All engines except for Amazon DocumentDB
     * + `db.sql.stats` (per-SQL metrics) - All engines except for Amazon DocumentDB
     * + `db.sql_tokenized.stats` (per-SQL digest metrics) - All engines except for Amazon DocumentDB
     */
    public val metricTypes: List<String>? = builder.metricTypes
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by `MaxRecords`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services service for which Performance Insights returns metrics.
     */
    public val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAvailableResourceMetricsRequest(")
        append("identifier=$identifier,")
        append("maxResults=$maxResults,")
        append("metricTypes=$metricTypes,")
        append("nextToken=$nextToken,")
        append("serviceType=$serviceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metricTypes?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAvailableResourceMetricsRequest

        if (identifier != other.identifier) return false
        if (maxResults != other.maxResults) return false
        if (metricTypes != other.metricTypes) return false
        if (nextToken != other.nextToken) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VWZ`.
         */
        public var identifier: kotlin.String? = null
        /**
         * The maximum number of items to return. If the `MaxRecords` value is less than the number of existing items, the response includes a pagination token.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The types of metrics to return in the response. Valid values in the array include the following:
         * + `os` (OS counter metrics) - All engines
         * + `db` (DB load metrics) - All engines except for Amazon DocumentDB
         * + `db.sql.stats` (per-SQL metrics) - All engines except for Amazon DocumentDB
         * + `db.sql_tokenized.stats` (per-SQL digest metrics) - All engines except for Amazon DocumentDB
         */
        public var metricTypes: List<String>? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by `MaxRecords`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services service for which Performance Insights returns metrics.
         */
        public var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest) : this() {
            this.identifier = x.identifier
            this.maxResults = x.maxResults
            this.metricTypes = x.metricTypes
            this.nextToken = x.nextToken
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest = ListAvailableResourceMetricsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
