// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetDimensionKeyDetailsRequest private constructor(builder: Builder) {
    /**
     * The name of the dimension group. Performance Insights searches the specified group for the dimension group ID. The following group name values are valid:
     * + `db.execution_plan` (Amazon RDS and Aurora only)
     * + `db.lock_snapshot` (Aurora only)
     * + `db.query` (Amazon DocumentDB only)
     * + `db.sql` (Amazon RDS and Aurora only)
     */
    public val group: kotlin.String? = builder.group
    /**
     * The ID of the dimension group from which to retrieve dimension details. For dimension group `db.sql`, the group ID is `db.sql.id`. The following group ID values are valid:
     * + `db.execution_plan.id` for dimension group `db.execution_plan` (Aurora and RDS only)
     * + `db.sql.id` for dimension group `db.sql` (Aurora and RDS only)
     * + `db.query.id` for dimension group `db.query` (DocumentDB only)
     * + For the dimension group `db.lock_snapshot`, the `GroupIdentifier` is the epoch timestamp when Performance Insights captured the snapshot, in seconds. You can retrieve this value with the `GetResourceMetrics` operation for a 1 second period.
     */
    public val groupIdentifier: kotlin.String? = builder.groupIdentifier
    /**
     * The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an Amazon Web Services Region. When a DB instance is the data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * A list of dimensions to retrieve the detail data for within the given dimension group. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group. Specify dimension names for the following dimension groups:
     * + `db.execution_plan` - Specify the dimension name `db.execution_plan.raw_plan` or the short dimension name `raw_plan` (Amazon RDS and Aurora only)
     * + `db.lock_snapshot` - Specify the dimension name `db.lock_snapshot.lock_trees` or the short dimension name `lock_trees`. (Aurora only)
     * + `db.sql` - Specify either the full dimension name `db.sql.statement` or the short dimension name `statement` (Aurora and RDS only).
     * + `db.query` - Specify either the full dimension name `db.query.statement` or the short dimension name `statement` (DocumentDB only).
     */
    public val requestedDimensions: List<String>? = builder.requestedDimensions
    /**
     * The Amazon Web Services service for which Performance Insights returns data. The only valid value is `RDS`.
     */
    public val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDimensionKeyDetailsRequest(")
        append("group=$group,")
        append("groupIdentifier=$groupIdentifier,")
        append("identifier=$identifier,")
        append("requestedDimensions=$requestedDimensions,")
        append("serviceType=$serviceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = group?.hashCode() ?: 0
        result = 31 * result + (groupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (requestedDimensions?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDimensionKeyDetailsRequest

        if (group != other.group) return false
        if (groupIdentifier != other.groupIdentifier) return false
        if (identifier != other.identifier) return false
        if (requestedDimensions != other.requestedDimensions) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the dimension group. Performance Insights searches the specified group for the dimension group ID. The following group name values are valid:
         * + `db.execution_plan` (Amazon RDS and Aurora only)
         * + `db.lock_snapshot` (Aurora only)
         * + `db.query` (Amazon DocumentDB only)
         * + `db.sql` (Amazon RDS and Aurora only)
         */
        public var group: kotlin.String? = null
        /**
         * The ID of the dimension group from which to retrieve dimension details. For dimension group `db.sql`, the group ID is `db.sql.id`. The following group ID values are valid:
         * + `db.execution_plan.id` for dimension group `db.execution_plan` (Aurora and RDS only)
         * + `db.sql.id` for dimension group `db.sql` (Aurora and RDS only)
         * + `db.query.id` for dimension group `db.query` (DocumentDB only)
         * + For the dimension group `db.lock_snapshot`, the `GroupIdentifier` is the epoch timestamp when Performance Insights captured the snapshot, in seconds. You can retrieve this value with the `GetResourceMetrics` operation for a 1 second period.
         */
        public var groupIdentifier: kotlin.String? = null
        /**
         * The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an Amazon Web Services Region. When a DB instance is the data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
         */
        public var identifier: kotlin.String? = null
        /**
         * A list of dimensions to retrieve the detail data for within the given dimension group. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group. Specify dimension names for the following dimension groups:
         * + `db.execution_plan` - Specify the dimension name `db.execution_plan.raw_plan` or the short dimension name `raw_plan` (Amazon RDS and Aurora only)
         * + `db.lock_snapshot` - Specify the dimension name `db.lock_snapshot.lock_trees` or the short dimension name `lock_trees`. (Aurora only)
         * + `db.sql` - Specify either the full dimension name `db.sql.statement` or the short dimension name `statement` (Aurora and RDS only).
         * + `db.query` - Specify either the full dimension name `db.query.statement` or the short dimension name `statement` (DocumentDB only).
         */
        public var requestedDimensions: List<String>? = null
        /**
         * The Amazon Web Services service for which Performance Insights returns data. The only valid value is `RDS`.
         */
        public var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsRequest) : this() {
            this.group = x.group
            this.groupIdentifier = x.groupIdentifier
            this.identifier = x.identifier
            this.requestedDimensions = x.requestedDimensions
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsRequest = GetDimensionKeyDetailsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
