// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that describes the details for a specified dimension.
 */
public class DimensionKeyDetail private constructor(builder: Builder) {
    /**
     * The full name of the dimension. The full name includes the group name and key name. The following values are valid:
     * + `db.query.statement` (Amazon DocumentDB)
     * + `db.sql.statement` (Amazon RDS and Aurora)
     */
    public val dimension: kotlin.String? = builder.dimension
    /**
     * The status of the dimension detail data. Possible values include the following:
     * + `AVAILABLE` - The dimension detail data is ready to be retrieved.
     * + `PROCESSING` - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status `PROCESSING`, Performance Insights returns the truncated query.
     * + `UNAVAILABLE` - The dimension detail data could not be collected successfully.
     */
    public val status: aws.sdk.kotlin.services.pi.model.DetailStatus? = builder.status
    /**
     * The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:
     * + `db.query.statement` (Amazon DocumentDB)
     * + `db.sql.statement` (Amazon RDS and Aurora)
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.DimensionKeyDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DimensionKeyDetail(")
        append("dimension=$dimension,")
        append("status=$status,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimension?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DimensionKeyDetail

        if (dimension != other.dimension) return false
        if (status != other.status) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.DimensionKeyDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The full name of the dimension. The full name includes the group name and key name. The following values are valid:
         * + `db.query.statement` (Amazon DocumentDB)
         * + `db.sql.statement` (Amazon RDS and Aurora)
         */
        public var dimension: kotlin.String? = null
        /**
         * The status of the dimension detail data. Possible values include the following:
         * + `AVAILABLE` - The dimension detail data is ready to be retrieved.
         * + `PROCESSING` - The dimension detail data isn't ready to be retrieved because more processing time is required. If the requested detail data has the status `PROCESSING`, Performance Insights returns the truncated query.
         * + `UNAVAILABLE` - The dimension detail data could not be collected successfully.
         */
        public var status: aws.sdk.kotlin.services.pi.model.DetailStatus? = null
        /**
         * The value of the dimension detail data. Depending on the return status, this value is either the full or truncated SQL query for the following dimensions:
         * + `db.query.statement` (Amazon DocumentDB)
         * + `db.sql.statement` (Amazon RDS and Aurora)
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.DimensionKeyDetail) : this() {
            this.dimension = x.dimension
            this.status = x.status
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.DimensionKeyDetail = DimensionKeyDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
