// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Retrieves the summary of the performance analysis report created for a time period.
 */
public class AnalysisReport private constructor(builder: Builder) {
    /**
     * The name of the analysis report.
     */
    public val analysisReportId: kotlin.String = requireNotNull(builder.analysisReportId) { "A non-null value must be provided for analysisReportId" }
    /**
     * The time you created the analysis report.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The analysis end time in the report.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The unique identifier of the analysis report.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * The list of identified insights in the analysis report.
     */
    public val insights: List<Insight>? = builder.insights
    /**
     * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
     * + `RDS`
     * + `DOCDB`
     */
    public val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType
    /**
     * The analysis start time in the report.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the created analysis report.
     */
    public val status: aws.sdk.kotlin.services.pi.model.AnalysisStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.AnalysisReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisReport(")
        append("analysisReportId=$analysisReportId,")
        append("createTime=$createTime,")
        append("endTime=$endTime,")
        append("identifier=$identifier,")
        append("insights=$insights,")
        append("serviceType=$serviceType,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisReportId.hashCode()
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (insights?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalysisReport

        if (analysisReportId != other.analysisReportId) return false
        if (createTime != other.createTime) return false
        if (endTime != other.endTime) return false
        if (identifier != other.identifier) return false
        if (insights != other.insights) return false
        if (serviceType != other.serviceType) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.AnalysisReport = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the analysis report.
         */
        public var analysisReportId: kotlin.String? = null
        /**
         * The time you created the analysis report.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The analysis end time in the report.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the analysis report.
         */
        public var identifier: kotlin.String? = null
        /**
         * The list of identified insights in the analysis report.
         */
        public var insights: List<Insight>? = null
        /**
         * List the tags for the Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
         * + `RDS`
         * + `DOCDB`
         */
        public var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null
        /**
         * The analysis start time in the report.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the created analysis report.
         */
        public var status: aws.sdk.kotlin.services.pi.model.AnalysisStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.AnalysisReport) : this() {
            this.analysisReportId = x.analysisReportId
            this.createTime = x.createTime
            this.endTime = x.endTime
            this.identifier = x.identifier
            this.insights = x.insights
            this.serviceType = x.serviceType
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.AnalysisReport = AnalysisReport(this)

        internal fun correctErrors(): Builder {
            if (analysisReportId == null) analysisReportId = ""
            return this
        }
    }
}
