// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.serde

import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysResponse
import aws.sdk.kotlin.services.pi.model.DimensionKeyDescription
import aws.sdk.kotlin.services.pi.model.PiException
import aws.sdk.kotlin.services.pi.model.ResponsePartitionKey
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeDimensionKeysOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDimensionKeysResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDimensionKeysResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDimensionKeysError(context, call, payload)
        }
        val builder = DescribeDimensionKeysResponse.Builder()

        if (payload != null) {
            deserializeDescribeDimensionKeysOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDimensionKeysError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PiException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDimensionKeysOperationBody(builder: DescribeDimensionKeysResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIGNEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedEndTime"))
    val ALIGNEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedStartTime"))
    val KEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Keys"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PARTITIONKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartitionKeys"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIGNEDENDTIME_DESCRIPTOR)
        field(ALIGNEDSTARTTIME_DESCRIPTOR)
        field(KEYS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PARTITIONKEYS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIGNEDENDTIME_DESCRIPTOR.index -> builder.alignedEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ALIGNEDSTARTTIME_DESCRIPTOR.index -> builder.alignedStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                KEYS_DESCRIPTOR.index -> builder.keys =
                    deserializer.deserializeList(KEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<DimensionKeyDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDimensionKeyDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PARTITIONKEYS_DESCRIPTOR.index -> builder.partitionKeys =
                    deserializer.deserializeList(PARTITIONKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResponsePartitionKey>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResponsePartitionKeyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
