// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetResourceMetricsRequest private constructor(builder: Builder) {
    /**
     * The date and time specifying the end of the requested time series query range. The value specified is *exclusive*. Thus, the command returns data points less than (but not equal to) `EndTime`.
     *
     * The value for `EndTime` must be later than the value for `StartTime`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights gathers metrics from this data source. In the console, the identifier is shown as *ResourceID*. When you call `DescribeDBInstances`, the identifier is returned as `DbiResourceId`.
     *
     * To use a DB instance as a data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * The maximum number of items to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify an aggregate function, and you can provide filtering criteria. You must append the aggregate function to the metric. For example, to find the average for the metric `db.load` you must use `db.load.avg`. Valid values for aggregate functions include `.avg`, `.min`, `.max`, and `.sum`.
     */
    public val metricQueries: List<MetricQuery>? = builder.metricQueries
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by `MaxRecords`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The returned timestamp which is the start or end time of the time periods. The default value is `END_TIME`.
     */
    public val periodAlignment: aws.sdk.kotlin.services.pi.model.PeriodAlignment? = builder.periodAlignment
    /**
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:
     * + `1` (one second)
     * + `60` (one minute)
     * + `300` (five minutes)
     * + `3600` (one hour)
     * + `86400` (twenty-four hours)
     *
     * If you don't specify `PeriodInSeconds`, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.
     */
    public val periodInSeconds: kotlin.Int? = builder.periodInSeconds
    /**
     * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
     * + `RDS`
     * + `DOCDB`
     */
    public val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType
    /**
     * The date and time specifying the beginning of the requested time series query range. You can't specify a `StartTime` that is earlier than 7 days ago. By default, Performance Insights has 7 days of retention, but you can extend this range up to 2 years. The value specified is *inclusive*. Thus, the command returns data points equal to or greater than `StartTime`.
     *
     * The value for `StartTime` must be earlier than the value for `EndTime`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourceMetricsRequest(")
        append("endTime=$endTime,")
        append("identifier=$identifier,")
        append("maxResults=$maxResults,")
        append("metricQueries=$metricQueries,")
        append("nextToken=$nextToken,")
        append("periodAlignment=$periodAlignment,")
        append("periodInSeconds=$periodInSeconds,")
        append("serviceType=$serviceType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metricQueries?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (periodAlignment?.hashCode() ?: 0)
        result = 31 * result + (periodInSeconds ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetResourceMetricsRequest

        if (endTime != other.endTime) return false
        if (identifier != other.identifier) return false
        if (maxResults != other.maxResults) return false
        if (metricQueries != other.metricQueries) return false
        if (nextToken != other.nextToken) return false
        if (periodAlignment != other.periodAlignment) return false
        if (periodInSeconds != other.periodInSeconds) return false
        if (serviceType != other.serviceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time specifying the end of the requested time series query range. The value specified is *exclusive*. Thus, the command returns data points less than (but not equal to) `EndTime`.
         *
         * The value for `EndTime` must be later than the value for `StartTime`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights gathers metrics from this data source. In the console, the identifier is shown as *ResourceID*. When you call `DescribeDBInstances`, the identifier is returned as `DbiResourceId`.
         *
         * To use a DB instance as a data source, specify its `DbiResourceId` value. For example, specify `db-ABCDEFGHIJKLMNOPQRSTU1VW2X`.
         */
        public var identifier: kotlin.String? = null
        /**
         * The maximum number of items to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify an aggregate function, and you can provide filtering criteria. You must append the aggregate function to the metric. For example, to find the average for the metric `db.load` you must use `db.load.avg`. Valid values for aggregate functions include `.avg`, `.min`, `.max`, and `.sum`.
         */
        public var metricQueries: List<MetricQuery>? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by `MaxRecords`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The returned timestamp which is the start or end time of the time periods. The default value is `END_TIME`.
         */
        public var periodAlignment: aws.sdk.kotlin.services.pi.model.PeriodAlignment? = null
        /**
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:
         * + `1` (one second)
         * + `60` (one minute)
         * + `300` (five minutes)
         * + `3600` (one hour)
         * + `86400` (twenty-four hours)
         *
         * If you don't specify `PeriodInSeconds`, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.
         */
        public var periodInSeconds: kotlin.Int? = null
        /**
         * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
         * + `RDS`
         * + `DOCDB`
         */
        public var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null
        /**
         * The date and time specifying the beginning of the requested time series query range. You can't specify a `StartTime` that is earlier than 7 days ago. By default, Performance Insights has 7 days of retention, but you can extend this range up to 2 years. The value specified is *inclusive*. Thus, the command returns data points equal to or greater than `StartTime`.
         *
         * The value for `StartTime` must be earlier than the value for `EndTime`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest) : this() {
            this.endTime = x.endTime
            this.identifier = x.identifier
            this.maxResults = x.maxResults
            this.metricQueries = x.metricQueries
            this.nextToken = x.nextToken
            this.periodAlignment = x.periodAlignment
            this.periodInSeconds = x.periodInSeconds
            this.serviceType = x.serviceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = GetResourceMetricsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
