// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single query to be processed. You must provide the metric to query and append an aggregate function to the metric. For example, to find the average for the metric `db.load` you must use `db.load.avg`. Valid values for aggregate functions include `.avg`, `.min`, `.max`, and `.sum`. If no other parameters are specified, Performance Insights returns all data points for the specified metric. Optionally, you can request that the data points be aggregated by dimension group (`GroupBy`), and return only those data points that match your criteria (`Filter`).
 */
public class MetricQuery private constructor(builder: Builder) {
    /**
     * One or more filters to apply in the request. Restrictions:
     * + Any number of filters by the same dimension, as specified in the `GroupBy` parameter.
     * + A single filter for any other dimension in this dimension group.
     *
     * The `db.sql.db_id` filter isn't available for RDS for SQL Server DB instances.
     */
    public val filter: Map<String, String>? = builder.filter
    /**
     * A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
     */
    public val groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = builder.groupBy
    /**
     * The name of a Performance Insights metric to be measured.
     *
     * Valid values for `Metric` are:
     * + `db.load.avg` - A scaled representation of the number of active sessions for the database engine.
     * + `db.sampledload.avg` - The raw number of active sessions for the database engine.
     * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon Aurora User Guide*.
     * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon RDS User Guide*.
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
     */
    public val metric: kotlin.String = requireNotNull(builder.metric) { "A non-null value must be provided for metric" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.MetricQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricQuery(")
        append("filter=$filter,")
        append("groupBy=$groupBy,")
        append("metric=$metric")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (metric.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricQuery

        if (filter != other.filter) return false
        if (groupBy != other.groupBy) return false
        if (metric != other.metric) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.MetricQuery = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One or more filters to apply in the request. Restrictions:
         * + Any number of filters by the same dimension, as specified in the `GroupBy` parameter.
         * + A single filter for any other dimension in this dimension group.
         *
         * The `db.sql.db_id` filter isn't available for RDS for SQL Server DB instances.
         */
        public var filter: Map<String, String>? = null
        /**
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.
         */
        public var groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = null
        /**
         * The name of a Performance Insights metric to be measured.
         *
         * Valid values for `Metric` are:
         * + `db.load.avg` - A scaled representation of the number of active sessions for the database engine.
         * + `db.sampledload.avg` - The raw number of active sessions for the database engine.
         * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon Aurora User Guide*.
         * + The counter metrics listed in [Performance Insights operating system counters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS) in the *Amazon RDS User Guide*.
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, `db.load.avg` and `db.sampledload.avg` are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with `db.load.avg` showing the scaled values, `db.sampledload.avg` showing the raw values, and `db.sampledload.avg` less than `db.load.avg`. For most use cases, you can query `db.load.avg` only.
         */
        public var metric: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.MetricQuery) : this() {
            this.filter = x.filter
            this.groupBy = x.groupBy
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.MetricQuery = MetricQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.pi.model.DimensionGroup] inside the given [block]
         */
        public fun groupBy(block: aws.sdk.kotlin.services.pi.model.DimensionGroup.Builder.() -> kotlin.Unit) {
            this.groupBy = aws.sdk.kotlin.services.pi.model.DimensionGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (metric == null) metric = ""
            return this
        }
    }
}
