// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Retrieves the list of performance issues which are identified.
 */
public class Insight private constructor(builder: Builder) {
    /**
     * Metric names and values from the timeframe used as baseline to generate the insight.
     */
    public val baselineData: List<Data>? = builder.baselineData
    /**
     * Indicates if the insight is causal or correlated insight.
     */
    public val context: aws.sdk.kotlin.services.pi.model.ContextType? = builder.context
    /**
     * Description of the insight. For example: `A high severity Insight found between 02:00 to 02:30, where there was an unusually high DB load 600x above baseline. Likely performance impact`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The end time of the insight. For example, `2018-10-30T00:00:00Z`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * List of data objects containing metrics and references from the time range while generating the insight.
     */
    public val insightData: List<Data>? = builder.insightData
    /**
     * The unique identifier for the insight. For example, `insight-12345678901234567`.
     */
    public val insightId: kotlin.String = requireNotNull(builder.insightId) { "A non-null value must be provided for insightId" }
    /**
     * The type of insight. For example, `HighDBLoad`, `HighCPU`, or `DominatingSQLs`.
     */
    public val insightType: kotlin.String? = builder.insightType
    /**
     * List of recommendations for the insight. For example, `Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id`.
     */
    public val recommendations: List<Recommendation>? = builder.recommendations
    /**
     * The severity of the insight. The values are: `Low`, `Medium`, or `High`.
     */
    public val severity: aws.sdk.kotlin.services.pi.model.Severity? = builder.severity
    /**
     * The start time of the insight. For example, `2018-10-30T00:00:00Z`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * List of supporting insights that provide additional factors for the insight.
     */
    public val supportingInsights: List<Insight>? = builder.supportingInsights

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.Insight = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Insight(")
        append("baselineData=$baselineData,")
        append("context=$context,")
        append("description=*** Sensitive Data Redacted ***,")
        append("endTime=$endTime,")
        append("insightData=$insightData,")
        append("insightId=$insightId,")
        append("insightType=$insightType,")
        append("recommendations=$recommendations,")
        append("severity=$severity,")
        append("startTime=$startTime,")
        append("supportingInsights=$supportingInsights")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineData?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (insightData?.hashCode() ?: 0)
        result = 31 * result + (insightId.hashCode())
        result = 31 * result + (insightType?.hashCode() ?: 0)
        result = 31 * result + (recommendations?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (supportingInsights?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Insight

        if (baselineData != other.baselineData) return false
        if (context != other.context) return false
        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (insightData != other.insightData) return false
        if (insightId != other.insightId) return false
        if (insightType != other.insightType) return false
        if (recommendations != other.recommendations) return false
        if (severity != other.severity) return false
        if (startTime != other.startTime) return false
        if (supportingInsights != other.supportingInsights) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.Insight = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Metric names and values from the timeframe used as baseline to generate the insight.
         */
        public var baselineData: List<Data>? = null
        /**
         * Indicates if the insight is causal or correlated insight.
         */
        public var context: aws.sdk.kotlin.services.pi.model.ContextType? = null
        /**
         * Description of the insight. For example: `A high severity Insight found between 02:00 to 02:30, where there was an unusually high DB load 600x above baseline. Likely performance impact`.
         */
        public var description: kotlin.String? = null
        /**
         * The end time of the insight. For example, `2018-10-30T00:00:00Z`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of data objects containing metrics and references from the time range while generating the insight.
         */
        public var insightData: List<Data>? = null
        /**
         * The unique identifier for the insight. For example, `insight-12345678901234567`.
         */
        public var insightId: kotlin.String? = null
        /**
         * The type of insight. For example, `HighDBLoad`, `HighCPU`, or `DominatingSQLs`.
         */
        public var insightType: kotlin.String? = null
        /**
         * List of recommendations for the insight. For example, `Investigate the following SQLs that contributed to 100% of the total DBLoad during that time period: sql-id`.
         */
        public var recommendations: List<Recommendation>? = null
        /**
         * The severity of the insight. The values are: `Low`, `Medium`, or `High`.
         */
        public var severity: aws.sdk.kotlin.services.pi.model.Severity? = null
        /**
         * The start time of the insight. For example, `2018-10-30T00:00:00Z`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of supporting insights that provide additional factors for the insight.
         */
        public var supportingInsights: List<Insight>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.Insight) : this() {
            this.baselineData = x.baselineData
            this.context = x.context
            this.description = x.description
            this.endTime = x.endTime
            this.insightData = x.insightData
            this.insightId = x.insightId
            this.insightType = x.insightType
            this.recommendations = x.recommendations
            this.severity = x.severity
            this.startTime = x.startTime
            this.supportingInsights = x.supportingInsights
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.Insight = Insight(this)

        internal fun correctErrors(): Builder {
            if (insightId == null) insightId = ""
            return this
        }
    }
}
