// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents action metadata added to an Action dataset using the `PutActions` API. For more information see [Importing actions individually](https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html).
 */
public class Action private constructor(builder: Builder) {
    /**
     * The ID associated with the action.
     */
    public val actionId: kotlin.String = requireNotNull(builder.actionId) { "A non-null value must be provided for actionId" }
    /**
     * A string map of action-specific metadata. Each element in the map consists of a key-value pair. For example, `{"value": "100"}`.
     *
     * The keys use camel case names that match the fields in the schema for the Actions dataset. In the previous example, the `value` matches the 'VALUE' field defined in the Actions schema. For categorical string data, to include multiple categories for a single action, separate each category with a pipe separator (`|`). For example, `\"Deluxe|Premium\"`.
     */
    public val properties: kotlin.String? = builder.properties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeevents.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("actionId=$actionId,")
        append("properties=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId.hashCode()
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (actionId != other.actionId) return false
        if (properties != other.properties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeevents.model.Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID associated with the action.
         */
        public var actionId: kotlin.String? = null
        /**
         * A string map of action-specific metadata. Each element in the map consists of a key-value pair. For example, `{"value": "100"}`.
         *
         * The keys use camel case names that match the fields in the schema for the Actions dataset. In the previous example, the `value` matches the 'VALUE' field defined in the Actions schema. For categorical string data, to include multiple categories for a single action, separate each category with a pipe separator (`|`). For example, `\"Deluxe|Premium\"`.
         */
        public var properties: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeevents.model.Action) : this() {
            this.actionId = x.actionId
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeevents.model.Action = Action(this)

        internal fun correctErrors(): Builder {
            if (actionId == null) actionId = ""
            return this
        }
    }
}
