// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents item interaction event information sent using the `PutEvents` API.
 */
public class Event private constructor(builder: Builder) {
    /**
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.
     */
    public val eventId: kotlin.String? = builder.eventId
    /**
     * The type of event, such as click or download. This property corresponds to the `EVENT_TYPE` field of your Item interactions dataset's schema and depends on the types of events you are tracking.
     */
    public val eventType: kotlin.String = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The event value that corresponds to the `EVENT_VALUE` field of the Item interactions schema.
     */
    public val eventValue: kotlin.Float? = builder.eventValue
    /**
     * A list of item IDs that represents the sequence of items you have shown the user. For example, `["itemId1", "itemId2", "itemId3"]`. Provide a list of items to manually record impressions data for an event. For more information on recording impressions data, see [Recording impressions data](https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data).
     */
    public val impression: List<String>? = builder.impression
    /**
     * The item ID key that corresponds to the `ITEM_ID` field of the Item interactions dataset's schema.
     */
    public val itemId: kotlin.String? = builder.itemId
    /**
     * Contains information about the metric attribution associated with an event. For more information about metric attributions, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
     */
    public val metricAttribution: aws.sdk.kotlin.services.personalizeevents.model.MetricAttribution? = builder.metricAttribution
    /**
     * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your site, other than movie ID (`itemId`) and rating (`eventValue`) , you might also send the number of movie ratings made by the user.
     *
     * Each item in the map consists of a key-value pair. For example,
     *
     * `{"numberOfRatings": "12"}`
     *
     * The keys use camel case names that match the fields in the Item interactions dataset's schema. In the above example, the `numberOfRatings` would match the 'NUMBER_OF_RATINGS' field defined in the Item interactions dataset's schema.
     *
     *  The following can't be included as a keyword for properties (case insensitive).
     * +  userId
     * +  sessionId
     * + eventType
     * + timestamp
     * + recommendationId
     * + impression
     */
    public val properties: kotlin.String? = builder.properties
    /**
     * The ID of the list of recommendations that contains the item the user interacted with. Provide a `recommendationId` to have Amazon Personalize implicitly record the recommendations you show your user as impressions data. Or provide a `recommendationId` if you use a metric attribution to measure the impact of recommendations.
     *
     *  For more information on recording impressions data, see [Recording impressions data](https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data). For more information on creating a metric attribution see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
     */
    public val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * The timestamp (in Unix time) on the client side when the event occurred.
     */
    public val sentAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sentAt) { "A non-null value must be provided for sentAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeevents.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventId?.hashCode() ?: 0
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (eventValue?.hashCode() ?: 0)
        result = 31 * result + (impression?.hashCode() ?: 0)
        result = 31 * result + (itemId?.hashCode() ?: 0)
        result = 31 * result + (metricAttribution?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (sentAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (eventId != other.eventId) return false
        if (eventType != other.eventType) return false
        if (!(eventValue?.equals(other.eventValue) ?: (other.eventValue == null))) return false
        if (impression != other.impression) return false
        if (itemId != other.itemId) return false
        if (metricAttribution != other.metricAttribution) return false
        if (properties != other.properties) return false
        if (recommendationId != other.recommendationId) return false
        if (sentAt != other.sentAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeevents.model.Event = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.
         */
        public var eventId: kotlin.String? = null
        /**
         * The type of event, such as click or download. This property corresponds to the `EVENT_TYPE` field of your Item interactions dataset's schema and depends on the types of events you are tracking.
         */
        public var eventType: kotlin.String? = null
        /**
         * The event value that corresponds to the `EVENT_VALUE` field of the Item interactions schema.
         */
        public var eventValue: kotlin.Float? = null
        /**
         * A list of item IDs that represents the sequence of items you have shown the user. For example, `["itemId1", "itemId2", "itemId3"]`. Provide a list of items to manually record impressions data for an event. For more information on recording impressions data, see [Recording impressions data](https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data).
         */
        public var impression: List<String>? = null
        /**
         * The item ID key that corresponds to the `ITEM_ID` field of the Item interactions dataset's schema.
         */
        public var itemId: kotlin.String? = null
        /**
         * Contains information about the metric attribution associated with an event. For more information about metric attributions, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
         */
        public var metricAttribution: aws.sdk.kotlin.services.personalizeevents.model.MetricAttribution? = null
        /**
         * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your site, other than movie ID (`itemId`) and rating (`eventValue`) , you might also send the number of movie ratings made by the user.
         *
         * Each item in the map consists of a key-value pair. For example,
         *
         * `{"numberOfRatings": "12"}`
         *
         * The keys use camel case names that match the fields in the Item interactions dataset's schema. In the above example, the `numberOfRatings` would match the 'NUMBER_OF_RATINGS' field defined in the Item interactions dataset's schema.
         *
         *  The following can't be included as a keyword for properties (case insensitive).
         * +  userId
         * +  sessionId
         * + eventType
         * + timestamp
         * + recommendationId
         * + impression
         */
        public var properties: kotlin.String? = null
        /**
         * The ID of the list of recommendations that contains the item the user interacted with. Provide a `recommendationId` to have Amazon Personalize implicitly record the recommendations you show your user as impressions data. Or provide a `recommendationId` if you use a metric attribution to measure the impact of recommendations.
         *
         *  For more information on recording impressions data, see [Recording impressions data](https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data). For more information on creating a metric attribution see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
         */
        public var recommendationId: kotlin.String? = null
        /**
         * The timestamp (in Unix time) on the client side when the event occurred.
         */
        public var sentAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeevents.model.Event) : this() {
            this.eventId = x.eventId
            this.eventType = x.eventType
            this.eventValue = x.eventValue
            this.impression = x.impression
            this.itemId = x.itemId
            this.metricAttribution = x.metricAttribution
            this.properties = x.properties
            this.recommendationId = x.recommendationId
            this.sentAt = x.sentAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeevents.model.Event = Event(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalizeevents.model.MetricAttribution] inside the given [block]
         */
        public fun metricAttribution(block: aws.sdk.kotlin.services.personalizeevents.model.MetricAttribution.Builder.() -> kotlin.Unit) {
            this.metricAttribution = aws.sdk.kotlin.services.personalizeevents.model.MetricAttribution.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = ""
            if (sentAt == null) sentAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
