// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an action interaction event sent using the `PutActionInteractions` API.
 */
public class ActionInteraction private constructor(builder: Builder) {
    /**
     * The ID of the action the user interacted with. This corresponds to the `ACTION_ID` field of the Action interaction schema.
     */
    public val actionId: kotlin.String = requireNotNull(builder.actionId) { "A non-null value must be provided for actionId" }
    /**
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.
     */
    public val eventId: kotlin.String? = builder.eventId
    /**
     * The type of action interaction event. You can specify `Viewed`, `Taken`, and `Not Taken` event types. For more information about action interaction event type data, see [Event type data](https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html).
     */
    public val eventType: kotlin.String = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * A list of action IDs that represents the sequence of actions you have shown the user. For example, `["actionId1", "actionId2", "actionId3"]`. Amazon Personalize doesn't use impressions data from action interaction events. Instead, record multiple events for each action and use the `Viewed` event type.
     */
    public val impression: List<String>? = builder.impression
    /**
     * A string map of event-specific data that you might choose to record. For example, if a user takes an action, other than the action ID, you might also send the number of actions taken by the user.
     *
     * Each item in the map consists of a key-value pair. For example,
     *
     * `{"numberOfActions": "12"}`
     *
     * The keys use camel case names that match the fields in the Action interactions schema. In the above example, the `numberOfActions` would match the 'NUMBER_OF_ACTIONS' field defined in the Action interactions schema.
     *
     *  The following can't be included as a keyword for properties (case insensitive).
     * +  userId
     * +  sessionId
     * + eventType
     * + timestamp
     * + recommendationId
     * + impression
     */
    public val properties: kotlin.String? = builder.properties
    /**
     * The ID of the list of recommendations that contains the action the user interacted with.
     */
    public val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * The ID associated with the user's visit. Your application generates a unique `sessionId` when a user first visits your website or uses your application.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time format, in seconds.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }
    /**
     * The ID of the user who interacted with the action. This corresponds to the `USER_ID` field of the Action interaction schema.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeevents.model.ActionInteraction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionInteraction(")
        append("actionId=*** Sensitive Data Redacted ***,")
        append("eventId=$eventId,")
        append("eventType=$eventType,")
        append("impression=*** Sensitive Data Redacted ***,")
        append("properties=*** Sensitive Data Redacted ***,")
        append("recommendationId=$recommendationId,")
        append("sessionId=$sessionId,")
        append("timestamp=$timestamp,")
        append("userId=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId.hashCode()
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (impression?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (timestamp.hashCode())
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionInteraction

        if (actionId != other.actionId) return false
        if (eventId != other.eventId) return false
        if (eventType != other.eventType) return false
        if (impression != other.impression) return false
        if (properties != other.properties) return false
        if (recommendationId != other.recommendationId) return false
        if (sessionId != other.sessionId) return false
        if (timestamp != other.timestamp) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeevents.model.ActionInteraction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the action the user interacted with. This corresponds to the `ACTION_ID` field of the Action interaction schema.
         */
        public var actionId: kotlin.String? = null
        /**
         * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.
         */
        public var eventId: kotlin.String? = null
        /**
         * The type of action interaction event. You can specify `Viewed`, `Taken`, and `Not Taken` event types. For more information about action interaction event type data, see [Event type data](https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html).
         */
        public var eventType: kotlin.String? = null
        /**
         * A list of action IDs that represents the sequence of actions you have shown the user. For example, `["actionId1", "actionId2", "actionId3"]`. Amazon Personalize doesn't use impressions data from action interaction events. Instead, record multiple events for each action and use the `Viewed` event type.
         */
        public var impression: List<String>? = null
        /**
         * A string map of event-specific data that you might choose to record. For example, if a user takes an action, other than the action ID, you might also send the number of actions taken by the user.
         *
         * Each item in the map consists of a key-value pair. For example,
         *
         * `{"numberOfActions": "12"}`
         *
         * The keys use camel case names that match the fields in the Action interactions schema. In the above example, the `numberOfActions` would match the 'NUMBER_OF_ACTIONS' field defined in the Action interactions schema.
         *
         *  The following can't be included as a keyword for properties (case insensitive).
         * +  userId
         * +  sessionId
         * + eventType
         * + timestamp
         * + recommendationId
         * + impression
         */
        public var properties: kotlin.String? = null
        /**
         * The ID of the list of recommendations that contains the action the user interacted with.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * The ID associated with the user's visit. Your application generates a unique `sessionId` when a user first visits your website or uses your application.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time format, in seconds.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the user who interacted with the action. This corresponds to the `USER_ID` field of the Action interaction schema.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeevents.model.ActionInteraction) : this() {
            this.actionId = x.actionId
            this.eventId = x.eventId
            this.eventType = x.eventType
            this.impression = x.impression
            this.properties = x.properties
            this.recommendationId = x.recommendationId
            this.sessionId = x.sessionId
            this.timestamp = x.timestamp
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeevents.model.ActionInteraction = ActionInteraction(this)

        internal fun correctErrors(): Builder {
            if (actionId == null) actionId = ""
            if (eventType == null) eventType = ""
            if (sessionId == null) sessionId = ""
            if (timestamp == null) timestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
