// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents item metadata added to an Items dataset using the `PutItems` API. For more information see [Importing items individually](https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html).
 */
public class Item private constructor(builder: Builder) {
    /**
     * The ID associated with the item.
     */
    public val itemId: kotlin.String = requireNotNull(builder.itemId) { "A non-null value must be provided for itemId" }
    /**
     * A string map of item-specific metadata. Each element in the map consists of a key-value pair. For example, `{"numberOfRatings": "12"}`.
     *
     * The keys use camel case names that match the fields in the schema for the Items dataset. In the previous example, the `numberOfRatings` matches the 'NUMBER_OF_RATINGS' field defined in the Items schema. For categorical string data, to include multiple categories for a single item, separate each category with a pipe separator (`|`). For example, `\"Horror|Action\"`.
     */
    public val properties: kotlin.String? = builder.properties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeevents.model.Item = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Item(")
        append("itemId=$itemId,")
        append("properties=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = itemId.hashCode()
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Item

        if (itemId != other.itemId) return false
        if (properties != other.properties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeevents.model.Item = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID associated with the item.
         */
        public var itemId: kotlin.String? = null
        /**
         * A string map of item-specific metadata. Each element in the map consists of a key-value pair. For example, `{"numberOfRatings": "12"}`.
         *
         * The keys use camel case names that match the fields in the schema for the Items dataset. In the previous example, the `numberOfRatings` matches the 'NUMBER_OF_RATINGS' field defined in the Items schema. For categorical string data, to include multiple categories for a single item, separate each category with a pipe separator (`|`). For example, `\"Horror|Action\"`.
         */
        public var properties: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeevents.model.Item) : this() {
            this.itemId = x.itemId
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeevents.model.Item = Item(this)

        internal fun correctErrors(): Builder {
            if (itemId == null) itemId = ""
            return this
        }
    }
}
