// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents user metadata added to a Users dataset using the `PutUsers` API. For more information see [Importing users individually](https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html).
 */
public class User private constructor(builder: Builder) {
    /**
     * A string map of user-specific metadata. Each element in the map consists of a key-value pair. For example, `{"numberOfVideosWatched": "45"}`.
     *
     * The keys use camel case names that match the fields in the schema for the Users dataset. In the previous example, the `numberOfVideosWatched` matches the 'NUMBER_OF_VIDEOS_WATCHED' field defined in the Users schema. For categorical string data, to include multiple categories for a single user, separate each category with a pipe separator (`|`). For example, `\"Member|Frequent shopper\"`.
     */
    public val properties: kotlin.String? = builder.properties
    /**
     * The ID associated with the user.
     */
    public val userId: kotlin.String = requireNotNull(builder.userId) { "A non-null value must be provided for userId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeevents.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("properties=*** Sensitive Data Redacted ***,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = properties?.hashCode() ?: 0
        result = 31 * result + (userId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (properties != other.properties) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeevents.model.User = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string map of user-specific metadata. Each element in the map consists of a key-value pair. For example, `{"numberOfVideosWatched": "45"}`.
         *
         * The keys use camel case names that match the fields in the schema for the Users dataset. In the previous example, the `numberOfVideosWatched` matches the 'NUMBER_OF_VIDEOS_WATCHED' field defined in the Users schema. For categorical string data, to include multiple categories for a single user, separate each category with a pipe separator (`|`). For example, `\"Member|Frequent shopper\"`.
         */
        public var properties: kotlin.String? = null
        /**
         * The ID associated with the user.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeevents.model.User) : this() {
            this.properties = x.properties
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeevents.model.User = User(this)

        internal fun correctErrors(): Builder {
            if (userId == null) userId = ""
            return this
        }
    }
}
