// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeevents.serde

import aws.sdk.kotlin.services.personalizeevents.model.PersonalizeEventsException
import aws.sdk.kotlin.services.personalizeevents.model.PutActionsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutActionsOperationDeserializer: HttpDeserializer.NonStreaming<PutActionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutActionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutActionsError(context, call, payload)
        }
        val builder = PutActionsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutActionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeEventsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> PersonalizeEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
