// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.paginators

import aws.sdk.kotlin.services.personalize.PersonalizeClient
import aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary
import aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary
import aws.sdk.kotlin.services.personalize.model.CampaignSummary
import aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary
import aws.sdk.kotlin.services.personalize.model.DatasetGroupSummary
import aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary
import aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary
import aws.sdk.kotlin.services.personalize.model.DatasetSummary
import aws.sdk.kotlin.services.personalize.model.EventTrackerSummary
import aws.sdk.kotlin.services.personalize.model.FilterSummary
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListCampaignsRequest
import aws.sdk.kotlin.services.personalize.model.ListCampaignsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetsResponse
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersRequest
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersResponse
import aws.sdk.kotlin.services.personalize.model.ListFiltersRequest
import aws.sdk.kotlin.services.personalize.model.ListFiltersResponse
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionMetricsRequest
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionMetricsResponse
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionsRequest
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionsResponse
import aws.sdk.kotlin.services.personalize.model.ListRecipesRequest
import aws.sdk.kotlin.services.personalize.model.ListRecipesResponse
import aws.sdk.kotlin.services.personalize.model.ListRecommendersRequest
import aws.sdk.kotlin.services.personalize.model.ListRecommendersResponse
import aws.sdk.kotlin.services.personalize.model.ListSchemasRequest
import aws.sdk.kotlin.services.personalize.model.ListSchemasResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionsResponse
import aws.sdk.kotlin.services.personalize.model.MetricAttribute
import aws.sdk.kotlin.services.personalize.model.MetricAttributionSummary
import aws.sdk.kotlin.services.personalize.model.RecipeSummary
import aws.sdk.kotlin.services.personalize.model.RecommenderSummary
import aws.sdk.kotlin.services.personalize.model.SolutionSummary
import aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBatchInferenceJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchInferenceJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchInferenceJobsResponse]
 */
public fun PersonalizeClient.listBatchInferenceJobsPaginated(initialRequest: ListBatchInferenceJobsRequest = ListBatchInferenceJobsRequest { }): Flow<ListBatchInferenceJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchInferenceJobsPaginated.listBatchInferenceJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchInferenceJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchInferenceJobsResponse]
 */
public fun PersonalizeClient.listBatchInferenceJobsPaginated(block: ListBatchInferenceJobsRequest.Builder.() -> Unit): Flow<ListBatchInferenceJobsResponse> =
    listBatchInferenceJobsPaginated(ListBatchInferenceJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchInferenceJobsPaginated]
 * to access the nested member [BatchInferenceJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchInferenceJobSummary]
 */
@JvmName("listBatchInferenceJobsResponseBatchInferenceJobSummary")
public fun Flow<ListBatchInferenceJobsResponse>.batchInferenceJobs(): Flow<BatchInferenceJobSummary> =
    transform() { response ->
        response.batchInferenceJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBatchSegmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchSegmentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchSegmentJobsResponse]
 */
public fun PersonalizeClient.listBatchSegmentJobsPaginated(initialRequest: ListBatchSegmentJobsRequest = ListBatchSegmentJobsRequest { }): Flow<ListBatchSegmentJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchSegmentJobsPaginated.listBatchSegmentJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchSegmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchSegmentJobsResponse]
 */
public fun PersonalizeClient.listBatchSegmentJobsPaginated(block: ListBatchSegmentJobsRequest.Builder.() -> Unit): Flow<ListBatchSegmentJobsResponse> =
    listBatchSegmentJobsPaginated(ListBatchSegmentJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchSegmentJobsPaginated]
 * to access the nested member [BatchSegmentJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchSegmentJobSummary]
 */
@JvmName("listBatchSegmentJobsResponseBatchSegmentJobSummary")
public fun Flow<ListBatchSegmentJobsResponse>.batchSegmentJobs(): Flow<BatchSegmentJobSummary> =
    transform() { response ->
        response.batchSegmentJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun PersonalizeClient.listCampaignsPaginated(initialRequest: ListCampaignsRequest = ListCampaignsRequest { }): Flow<ListCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCampaignsPaginated.listCampaigns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun PersonalizeClient.listCampaignsPaginated(block: ListCampaignsRequest.Builder.() -> Unit): Flow<ListCampaignsResponse> =
    listCampaignsPaginated(ListCampaignsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCampaignsPaginated]
 * to access the nested member [CampaignSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CampaignSummary]
 */
@JvmName("listCampaignsResponseCampaignSummary")
public fun Flow<ListCampaignsResponse>.campaigns(): Flow<CampaignSummary> =
    transform() { response ->
        response.campaigns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetExportJobsResponse]
 */
public fun PersonalizeClient.listDatasetExportJobsPaginated(initialRequest: ListDatasetExportJobsRequest = ListDatasetExportJobsRequest { }): Flow<ListDatasetExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetExportJobsPaginated.listDatasetExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetExportJobsResponse]
 */
public fun PersonalizeClient.listDatasetExportJobsPaginated(block: ListDatasetExportJobsRequest.Builder.() -> Unit): Flow<ListDatasetExportJobsResponse> =
    listDatasetExportJobsPaginated(ListDatasetExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetExportJobsPaginated]
 * to access the nested member [DatasetExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetExportJobSummary]
 */
@JvmName("listDatasetExportJobsResponseDatasetExportJobSummary")
public fun Flow<ListDatasetExportJobsResponse>.datasetExportJobs(): Flow<DatasetExportJobSummary> =
    transform() { response ->
        response.datasetExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
public fun PersonalizeClient.listDatasetGroupsPaginated(initialRequest: ListDatasetGroupsRequest = ListDatasetGroupsRequest { }): Flow<ListDatasetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetGroupsPaginated.listDatasetGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
public fun PersonalizeClient.listDatasetGroupsPaginated(block: ListDatasetGroupsRequest.Builder.() -> Unit): Flow<ListDatasetGroupsResponse> =
    listDatasetGroupsPaginated(ListDatasetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetGroupsPaginated]
 * to access the nested member [DatasetGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetGroupSummary]
 */
@JvmName("listDatasetGroupsResponseDatasetGroupSummary")
public fun Flow<ListDatasetGroupsResponse>.datasetGroups(): Flow<DatasetGroupSummary> =
    transform() { response ->
        response.datasetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
public fun PersonalizeClient.listDatasetImportJobsPaginated(initialRequest: ListDatasetImportJobsRequest = ListDatasetImportJobsRequest { }): Flow<ListDatasetImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetImportJobsPaginated.listDatasetImportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
public fun PersonalizeClient.listDatasetImportJobsPaginated(block: ListDatasetImportJobsRequest.Builder.() -> Unit): Flow<ListDatasetImportJobsResponse> =
    listDatasetImportJobsPaginated(ListDatasetImportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetImportJobsPaginated]
 * to access the nested member [DatasetImportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetImportJobSummary]
 */
@JvmName("listDatasetImportJobsResponseDatasetImportJobSummary")
public fun Flow<ListDatasetImportJobsResponse>.datasetImportJobs(): Flow<DatasetImportJobSummary> =
    transform() { response ->
        response.datasetImportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun PersonalizeClient.listDatasetsPaginated(initialRequest: ListDatasetsRequest = ListDatasetsRequest { }): Flow<ListDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetsPaginated.listDatasets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun PersonalizeClient.listDatasetsPaginated(block: ListDatasetsRequest.Builder.() -> Unit): Flow<ListDatasetsResponse> =
    listDatasetsPaginated(ListDatasetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetsPaginated]
 * to access the nested member [DatasetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetSummary]
 */
@JvmName("listDatasetsResponseDatasetSummary")
public fun Flow<ListDatasetsResponse>.datasets(): Flow<DatasetSummary> =
    transform() { response ->
        response.datasets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventTrackersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTrackersResponse]
 */
public fun PersonalizeClient.listEventTrackersPaginated(initialRequest: ListEventTrackersRequest = ListEventTrackersRequest { }): Flow<ListEventTrackersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventTrackersPaginated.listEventTrackers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTrackersResponse]
 */
public fun PersonalizeClient.listEventTrackersPaginated(block: ListEventTrackersRequest.Builder.() -> Unit): Flow<ListEventTrackersResponse> =
    listEventTrackersPaginated(ListEventTrackersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventTrackersPaginated]
 * to access the nested member [EventTrackerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventTrackerSummary]
 */
@JvmName("listEventTrackersResponseEventTrackerSummary")
public fun Flow<ListEventTrackersResponse>.eventTrackers(): Flow<EventTrackerSummary> =
    transform() { response ->
        response.eventTrackers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun PersonalizeClient.listFiltersPaginated(initialRequest: ListFiltersRequest = ListFiltersRequest { }): Flow<ListFiltersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFiltersPaginated.listFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun PersonalizeClient.listFiltersPaginated(block: ListFiltersRequest.Builder.() -> Unit): Flow<ListFiltersResponse> =
    listFiltersPaginated(ListFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFiltersPaginated]
 * to access the nested member [FilterSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FilterSummary]
 */
@JvmName("listFiltersResponseFilterSummary")
public fun Flow<ListFiltersResponse>.filters(): Flow<FilterSummary> =
    transform() { response ->
        response.filters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMetricAttributionMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMetricAttributionMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricAttributionMetricsResponse]
 */
public fun PersonalizeClient.listMetricAttributionMetricsPaginated(initialRequest: ListMetricAttributionMetricsRequest = ListMetricAttributionMetricsRequest { }): Flow<ListMetricAttributionMetricsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMetricAttributionMetricsPaginated.listMetricAttributionMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMetricAttributionMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricAttributionMetricsResponse]
 */
public fun PersonalizeClient.listMetricAttributionMetricsPaginated(block: ListMetricAttributionMetricsRequest.Builder.() -> Unit): Flow<ListMetricAttributionMetricsResponse> =
    listMetricAttributionMetricsPaginated(ListMetricAttributionMetricsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMetricAttributionMetricsPaginated]
 * to access the nested member [MetricAttribute]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MetricAttribute]
 */
@JvmName("listMetricAttributionMetricsResponseMetricAttribute")
public fun Flow<ListMetricAttributionMetricsResponse>.metrics(): Flow<MetricAttribute> =
    transform() { response ->
        response.metrics?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMetricAttributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMetricAttributionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricAttributionsResponse]
 */
public fun PersonalizeClient.listMetricAttributionsPaginated(initialRequest: ListMetricAttributionsRequest = ListMetricAttributionsRequest { }): Flow<ListMetricAttributionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMetricAttributionsPaginated.listMetricAttributions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMetricAttributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricAttributionsResponse]
 */
public fun PersonalizeClient.listMetricAttributionsPaginated(block: ListMetricAttributionsRequest.Builder.() -> Unit): Flow<ListMetricAttributionsResponse> =
    listMetricAttributionsPaginated(ListMetricAttributionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMetricAttributionsPaginated]
 * to access the nested member [MetricAttributionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MetricAttributionSummary]
 */
@JvmName("listMetricAttributionsResponseMetricAttributionSummary")
public fun Flow<ListMetricAttributionsResponse>.metricAttributions(): Flow<MetricAttributionSummary> =
    transform() { response ->
        response.metricAttributions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecipesResponse]
 */
public fun PersonalizeClient.listRecipesPaginated(initialRequest: ListRecipesRequest = ListRecipesRequest { }): Flow<ListRecipesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecipesPaginated.listRecipes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecipesResponse]
 */
public fun PersonalizeClient.listRecipesPaginated(block: ListRecipesRequest.Builder.() -> Unit): Flow<ListRecipesResponse> =
    listRecipesPaginated(ListRecipesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecipesPaginated]
 * to access the nested member [RecipeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecipeSummary]
 */
@JvmName("listRecipesResponseRecipeSummary")
public fun Flow<ListRecipesResponse>.recipes(): Flow<RecipeSummary> =
    transform() { response ->
        response.recipes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecommendersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendersResponse]
 */
public fun PersonalizeClient.listRecommendersPaginated(initialRequest: ListRecommendersRequest = ListRecommendersRequest { }): Flow<ListRecommendersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendersPaginated.listRecommenders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendersResponse]
 */
public fun PersonalizeClient.listRecommendersPaginated(block: ListRecommendersRequest.Builder.() -> Unit): Flow<ListRecommendersResponse> =
    listRecommendersPaginated(ListRecommendersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecommendersPaginated]
 * to access the nested member [RecommenderSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecommenderSummary]
 */
@JvmName("listRecommendersResponseRecommenderSummary")
public fun Flow<ListRecommendersResponse>.recommenders(): Flow<RecommenderSummary> =
    transform() { response ->
        response.recommenders?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
public fun PersonalizeClient.listSchemasPaginated(initialRequest: ListSchemasRequest = ListSchemasRequest { }): Flow<ListSchemasResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemasPaginated.listSchemas(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
public fun PersonalizeClient.listSchemasPaginated(block: ListSchemasRequest.Builder.() -> Unit): Flow<ListSchemasResponse> =
    listSchemasPaginated(ListSchemasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemasPaginated]
 * to access the nested member [DatasetSchemaSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetSchemaSummary]
 */
@JvmName("listSchemasResponseDatasetSchemaSummary")
public fun Flow<ListSchemasResponse>.schemas(): Flow<DatasetSchemaSummary> =
    transform() { response ->
        response.schemas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionsResponse]
 */
public fun PersonalizeClient.listSolutionsPaginated(initialRequest: ListSolutionsRequest = ListSolutionsRequest { }): Flow<ListSolutionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolutionsPaginated.listSolutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionsResponse]
 */
public fun PersonalizeClient.listSolutionsPaginated(block: ListSolutionsRequest.Builder.() -> Unit): Flow<ListSolutionsResponse> =
    listSolutionsPaginated(ListSolutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolutionsPaginated]
 * to access the nested member [SolutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SolutionSummary]
 */
@JvmName("listSolutionsResponseSolutionSummary")
public fun Flow<ListSolutionsResponse>.solutions(): Flow<SolutionSummary> =
    transform() { response ->
        response.solutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolutionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolutionVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionVersionsResponse]
 */
public fun PersonalizeClient.listSolutionVersionsPaginated(initialRequest: ListSolutionVersionsRequest = ListSolutionVersionsRequest { }): Flow<ListSolutionVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolutionVersionsPaginated.listSolutionVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolutionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionVersionsResponse]
 */
public fun PersonalizeClient.listSolutionVersionsPaginated(block: ListSolutionVersionsRequest.Builder.() -> Unit): Flow<ListSolutionVersionsResponse> =
    listSolutionVersionsPaginated(ListSolutionVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolutionVersionsPaginated]
 * to access the nested member [SolutionVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SolutionVersionSummary]
 */
@JvmName("listSolutionVersionsResponseSolutionVersionSummary")
public fun Flow<ListSolutionVersionsResponse>.solutionVersions(): Flow<SolutionVersionSummary> =
    transform() { response ->
        response.solutionVersions?.forEach {
            emit(it)
        }
    }
