// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateSolutionRequest private constructor(builder: Builder) {
    /**
     * Whether the solution uses automatic training to create new solution versions (trained models). You can change the training frequency by specifying a `schedulingExpression` in the `AutoTrainingConfig` as part of solution configuration.
     *
     *  If you turn on automatic training, the first automatic training starts within one hour after the solution update completes. If you manually create a solution version within the hour, the solution skips the first automatic training. For more information about automatic training, see [Configuring automatic training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
     *
     *  After training starts, you can get the solution version's Amazon Resource Name (ARN) with the [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html) API operation. To get its status, use the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html).
     */
    public val performAutoTraining: kotlin.Boolean? = builder.performAutoTraining
    /**
     * The Amazon Resource Name (ARN) of the solution to update.
     */
    public val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * The new configuration details of the solution.
     */
    public val solutionUpdateConfig: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig? = builder.solutionUpdateConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.UpdateSolutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSolutionRequest(")
        append("performAutoTraining=$performAutoTraining,")
        append("solutionArn=$solutionArn,")
        append("solutionUpdateConfig=$solutionUpdateConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = performAutoTraining?.hashCode() ?: 0
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (solutionUpdateConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSolutionRequest

        if (performAutoTraining != other.performAutoTraining) return false
        if (solutionArn != other.solutionArn) return false
        if (solutionUpdateConfig != other.solutionUpdateConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.UpdateSolutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether the solution uses automatic training to create new solution versions (trained models). You can change the training frequency by specifying a `schedulingExpression` in the `AutoTrainingConfig` as part of solution configuration.
         *
         *  If you turn on automatic training, the first automatic training starts within one hour after the solution update completes. If you manually create a solution version within the hour, the solution skips the first automatic training. For more information about automatic training, see [Configuring automatic training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
         *
         *  After training starts, you can get the solution version's Amazon Resource Name (ARN) with the [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html) API operation. To get its status, use the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html).
         */
        public var performAutoTraining: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the solution to update.
         */
        public var solutionArn: kotlin.String? = null
        /**
         * The new configuration details of the solution.
         */
        public var solutionUpdateConfig: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.UpdateSolutionRequest) : this() {
            this.performAutoTraining = x.performAutoTraining
            this.solutionArn = x.solutionArn
            this.solutionUpdateConfig = x.solutionUpdateConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.UpdateSolutionRequest = UpdateSolutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig] inside the given [block]
         */
        public fun solutionUpdateConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig.Builder.() -> kotlin.Unit) {
            this.solutionUpdateConfig = aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
