// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a solution version. For a complete listing, call the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html) API.
 */
public class SolutionVersionSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that this version of a solution was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a solution version fails, the reason behind the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the solution version was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The Amazon Resource Name (ARN) of the solution version.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the solution version.
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    public val status: kotlin.String? = builder.status
    /**
     * The scope of training to be performed when creating the solution version. A `FULL` training considers all of the data in your dataset group. An `UPDATE` processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use `UPDATE`.
     */
    public val trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = builder.trainingMode
    /**
     * Whether the solution version was created automatically or manually.
     */
    public val trainingType: aws.sdk.kotlin.services.personalize.model.TrainingType? = builder.trainingType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionVersionSummary(")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status,")
        append("trainingMode=$trainingMode,")
        append("trainingType=$trainingType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingMode?.hashCode() ?: 0)
        result = 31 * result + (trainingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionVersionSummary

        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false
        if (trainingMode != other.trainingMode) return false
        if (trainingType != other.trainingType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time (in Unix time) that this version of a solution was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a solution version fails, the reason behind the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution version was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the solution version.
         *
         * A solution version can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        public var status: kotlin.String? = null
        /**
         * The scope of training to be performed when creating the solution version. A `FULL` training considers all of the data in your dataset group. An `UPDATE` processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use `UPDATE`.
         */
        public var trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = null
        /**
         * Whether the solution version was created automatically or manually.
         */
        public var trainingType: aws.sdk.kotlin.services.personalize.model.TrainingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
            this.trainingMode = x.trainingMode
            this.trainingType = x.trainingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = SolutionVersionSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
