// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that provides information about a specific version of a [Solution](https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html) in a Custom dataset group.
 */
public class SolutionVersion private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that this version of the solution was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group providing the training data.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * If training a solution version fails, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the solution was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the solution version.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses `recipeArn`.
     */
    public val performAutoMl: kotlin.Boolean = builder.performAutoMl
    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
     */
    public val performHpo: kotlin.Boolean = builder.performHpo
    /**
     * The ARN of the recipe used in the solution.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The ARN of the solution.
     */
    public val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * Describes the configuration properties for the solution.
     */
    public val solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = builder.solutionConfig
    /**
     * The ARN of the solution version.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the solution version.
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     */
    public val status: kotlin.String? = builder.status
    /**
     * The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.
     */
    public val trainingHours: kotlin.Double? = builder.trainingHours
    /**
     * The scope of training to be performed when creating the solution version. A `FULL` training considers all of the data in your dataset group. An `UPDATE` processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use `UPDATE`.
     */
    public val trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = builder.trainingMode
    /**
     * Whether the solution version was created automatically or manually.
     */
    public val trainingType: aws.sdk.kotlin.services.personalize.model.TrainingType? = builder.trainingType
    /**
     * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.
     */
    public val tunedHpoParams: aws.sdk.kotlin.services.personalize.model.TunedHpoParams? = builder.tunedHpoParams

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionVersion(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventType=$eventType,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("performAutoMl=$performAutoMl,")
        append("performHpo=$performHpo,")
        append("recipeArn=$recipeArn,")
        append("solutionArn=$solutionArn,")
        append("solutionConfig=$solutionConfig,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status,")
        append("trainingHours=$trainingHours,")
        append("trainingMode=$trainingMode,")
        append("trainingType=$trainingType,")
        append("tunedHpoParams=$tunedHpoParams")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl.hashCode())
        result = 31 * result + (performHpo.hashCode())
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (solutionConfig?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingHours?.hashCode() ?: 0)
        result = 31 * result + (trainingMode?.hashCode() ?: 0)
        result = 31 * result + (trainingType?.hashCode() ?: 0)
        result = 31 * result + (tunedHpoParams?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionVersion

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventType != other.eventType) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performHpo != other.performHpo) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionArn != other.solutionArn) return false
        if (solutionConfig != other.solutionConfig) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false
        if (!(trainingHours?.equals(other.trainingHours) ?: (other.trainingHours == null))) return false
        if (trainingMode != other.trainingMode) return false
        if (trainingType != other.trainingType) return false
        if (tunedHpoParams != other.tunedHpoParams) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time (in Unix time) that this version of the solution was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group providing the training data.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The event type (for example, 'click' or 'like') that is used for training the model.
         */
        public var eventType: kotlin.String? = null
        /**
         * If training a solution version fails, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the solution version.
         */
        public var name: kotlin.String? = null
        /**
         * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses `recipeArn`.
         */
        public var performAutoMl: kotlin.Boolean = false
        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
         */
        public var performHpo: kotlin.Boolean = false
        /**
         * The ARN of the recipe used in the solution.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The ARN of the solution.
         */
        public var solutionArn: kotlin.String? = null
        /**
         * Describes the configuration properties for the solution.
         */
        public var solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = null
        /**
         * The ARN of the solution version.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the solution version.
         *
         * A solution version can be in one of the following states:
         * + CREATE PENDING
         * + CREATE IN_PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         * + CREATE STOPPING
         * + CREATE STOPPED
         */
        public var status: kotlin.String? = null
        /**
         * The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.
         */
        public var trainingHours: kotlin.Double? = null
        /**
         * The scope of training to be performed when creating the solution version. A `FULL` training considers all of the data in your dataset group. An `UPDATE` processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use `UPDATE`.
         */
        public var trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = null
        /**
         * Whether the solution version was created automatically or manually.
         */
        public var trainingType: aws.sdk.kotlin.services.personalize.model.TrainingType? = null
        /**
         * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.
         */
        public var tunedHpoParams: aws.sdk.kotlin.services.personalize.model.TunedHpoParams? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionVersion) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.eventType = x.eventType
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.performAutoMl = x.performAutoMl
            this.performHpo = x.performHpo
            this.recipeArn = x.recipeArn
            this.solutionArn = x.solutionArn
            this.solutionConfig = x.solutionConfig
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
            this.trainingHours = x.trainingHours
            this.trainingMode = x.trainingMode
            this.trainingType = x.trainingType
            this.tunedHpoParams = x.tunedHpoParams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionVersion = SolutionVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionConfig] inside the given [block]
         */
        public fun solutionConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionConfig.Builder.() -> kotlin.Unit) {
            this.solutionConfig = aws.sdk.kotlin.services.personalize.model.SolutionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.TunedHpoParams] inside the given [block]
         */
        public fun tunedHpoParams(block: aws.sdk.kotlin.services.personalize.model.TunedHpoParams.Builder.() -> kotlin.Unit) {
            this.tunedHpoParams = aws.sdk.kotlin.services.personalize.model.TunedHpoParams.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
